package ru.yandex.direct.cloud.mdb.mysql.api;

import ru.yandex.direct.cloud.iam.CloudApiConnectionInfo;
import ru.yandex.direct.cloud.iam.IIamTokenProvider;

/**
 * Класс для хранения параметров соединения api и поставщика iam-токенов
 */
public class BaseCloudApiHelper {
    private final IIamTokenProvider iamTokenProvider;
    private final CloudApiConnectionInfo connectionInfo;

    public BaseCloudApiHelper(CloudApiConnectionInfo connectionInfo, IIamTokenProvider iamTokenProvider) {
        this.connectionInfo = connectionInfo;
        this.iamTokenProvider = iamTokenProvider;
    }

    public IIamTokenProvider getIamTokenProvider() {
        return iamTokenProvider;
    }

    public CloudApiConnectionInfo getConnectionInfo() {
        return connectionInfo;
    }
}
