package ru.yandex.direct.cloud.mdb.mysql.api;

import java.io.Closeable;
import java.io.IOException;

import ru.yandex.direct.cloud.mdb.mysql.api.transport.GetClustersListRequest;
import ru.yandex.direct.cloud.mdb.mysql.api.transport.GetClustersListResponse;
import ru.yandex.direct.cloud.mdb.mysql.api.transport.GetLogRecordsListRequest;
import ru.yandex.direct.cloud.mdb.mysql.api.transport.GetLogRecordsListResponse;

/**
 * Интерфейс для взаимодействия с cloud mdb mySQL api
 */
public interface ICloudMdbMySqlApi extends Closeable {
    /**
     * Получение списка исходных записей выбранного лого указанного кластера облака
     * @param request запрос на получение списка исходных записей выбранного лого указанного кластера облака
     * @return список исходных записей выбранного лого указанного кластера облака
     * @throws IOException если что-то пошло не так с io
     * @throws InterruptedException если прервали поток выполнения
     */
    GetLogRecordsListResponse getLogRecordsList(GetLogRecordsListRequest request)
            throws IOException, InterruptedException;

    /**
     * Получение списка кластеров облака
     * @param request запрос на получение кластеров облака
     * @return список кластеров облака
     * @throws IOException если что-то пошло не так с io
     * @throws InterruptedException если прервали поток выполнения
     */
    GetClustersListResponse getClustersList(GetClustersListRequest request) throws IOException, InterruptedException;
}
