package ru.yandex.direct.cloud.mdb.mysql.api.grpc;

import java.io.IOException;

import ru.yandex.direct.cloud.iam.CloudApiConnectionInfo;
import ru.yandex.direct.cloud.iam.IIamTokenProvider;
import ru.yandex.direct.cloud.mdb.mysql.api.ICloudMdbMySqlApi;
import ru.yandex.direct.cloud.mdb.mysql.api.transport.GetClustersListRequest;
import ru.yandex.direct.cloud.mdb.mysql.api.transport.GetClustersListResponse;
import ru.yandex.direct.cloud.mdb.mysql.api.transport.GetLogRecordsListRequest;
import ru.yandex.direct.cloud.mdb.mysql.api.transport.GetLogRecordsListResponse;

/**
 * Реализация взаимодействия с cloud mdb mySQL api по протоколу gRPC
 */
public class GrpcCloudMdbMySqlApiImpl implements ICloudMdbMySqlApi {
    private final GrpcCloudApiHelper helper;

    public GrpcCloudMdbMySqlApiImpl(
            CloudApiConnectionInfo connectionInfo, IIamTokenProvider iamTokenProvider) {
        this.helper = new GrpcCloudApiHelper(connectionInfo, iamTokenProvider);
    }

    @Override
    public GetLogRecordsListResponse getLogRecordsList(GetLogRecordsListRequest request)
            throws IOException {
        return GrpcLogsRecordsReader.getLogRecordsList(helper, request);
    }

    @Override
    public GetClustersListResponse getClustersList(GetClustersListRequest request)
            throws IOException {
        return GrpcClustersReader.getClustersList(helper, request);
    }

    @Override
    public void close() {
        helper.close();
    }
}
