package ru.yandex.direct.cloud.mdb.mysql.api.transport;

public class GetClustersListRequest extends AbstractPagedRequest {
    private final String folderId;
    private final String filterString;

    public GetClustersListRequest(String folderId, int pageSize, String filterString, String nextPageToken) {
        super(pageSize, nextPageToken);
        this.folderId = folderId;
        this.filterString = filterString;
    }

    public GetClustersListRequest(String folderId, int pageSize, String nextPageToken) {
        this(folderId, pageSize, null, nextPageToken);
    }

    public String getFolderId() {
        return folderId;
    }

    public String getFilterString() {
        return filterString;
    }
}
