package ru.yandex.direct.cloud.mdb.mysql.api.transport;

import java.time.Instant;

public class GetLogRecordsListRequest extends AbstractClusterPagedRequest{
    private final LogTypeEnum logType;
    private final Instant from;

    public GetLogRecordsListRequest(
            String clusterId, LogTypeEnum logType, Instant from,
            String nextPageToken, int pageSize) {
        super(clusterId, pageSize, nextPageToken);
        this.logType = logType;
        this.from = from;
    }

    public LogTypeEnum getLogType() {
        return logType;
    }

    public Instant getFrom() {
        return from;
    }
}
