package ru.yandex.direct.libs.collections;

import javax.annotation.ParametersAreNonnullByDefault;

import ru.yandex.direct.http.smart.annotations.Json;
import ru.yandex.direct.http.smart.annotations.ResponseHandler;
import ru.yandex.direct.http.smart.core.Call;
import ru.yandex.direct.http.smart.http.GET;
import ru.yandex.direct.http.smart.http.Path;
import ru.yandex.direct.http.smart.http.Query;
import ru.yandex.direct.libs.collections.model.collection.CollectionsResponse;
import ru.yandex.direct.libs.collections.model.serpdata.CollectionSerpData;

@ParametersAreNonnullByDefault
public interface CollectionsApi {

    /**
     * Получение информации о коллекции.
     *
     * @param ownerLogin        логин владельца коллекции
     * @param collectionName    название коллекции
     */
    @GET("/boards")
    @Json
    Call<CollectionsResponse> getCollection(
            @Query("owner.login") String ownerLogin,
            @Query("slug") String collectionName);

    /**
     * Получение данных серпа о коллекции.
     *
     * @param collectionId  id коллекции
     */
    @GET("/boards/{board_id}/get_serp_data")
    @ResponseHandler(parserClass = CollectionsResponseConverter.class)
    Call<CollectionSerpData> getCollectionSerpData(
            @Path("board_id") String collectionId);
}
