package ru.yandex.direct.libs.collections;

import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

import org.asynchttpclient.Response;

import ru.yandex.direct.http.smart.converter.ResponseConverter;
import ru.yandex.direct.libs.collections.model.serpdata.CollectionSerpData;

public class CollectionsResponseConverter implements ResponseConverter<CollectionSerpData> {

    @Override
    public CollectionSerpData convert(Response response, Type responseType) {
        String responseBody = response.getResponseBody(StandardCharsets.UTF_8);
        return CollectionSerpData.fromJson(responseBody);
    }
}
