package ru.yandex.direct.libs.collections.model.serpdata;

import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

import ru.yandex.direct.utils.JsonUtils;

@JsonPropertyOrder(alphabetic = true)
public class CollectionSerpData {

    @JsonProperty("name")
    private String name;

    @JsonProperty("url")
    private String url;

    @JsonProperty("thumb_id")
    private String thumbId;

    @JsonProperty("cards_count")
    private int cardsCount;

    @JsonProperty("items")
    private List<Item> items;

    @JsonProperty("id")
    private String id;

    /**
     * Поле, представляющее собой полученный от Коллекций JSON (включая неописанные в {@link CollectionSerpData} ключи)
     * в нормализованном (ключи следуют в лексикографическом порядке) виде.
     */
    private String normalizedJson;

    public String getName() {
        return name;
    }

    public String getUrl() {
        return url;
    }

    public String getThumbId() {
        return thumbId;
    }

    public int getCardsCount() {
        return cardsCount;
    }

    public List<Item> getItems() {
        return items;
    }

    public String getId() {
        return id;
    }

    public String getNormalizedJson() {
        return normalizedJson;
    }

    private CollectionSerpData withNormalizedJson(String normalizedJson) {
        this.normalizedJson = normalizedJson;
        return this;
    }

    public static CollectionSerpData fromJson(String json) {
        @SuppressWarnings("unchecked")
        Map<String, Object> deserializedJson = JsonUtils.fromJson(json, Map.class);
        return CollectionSerpData.fromMap(deserializedJson);
    }

    public static CollectionSerpData fromMap(Map<String, Object> collectionSerpDataMap) {
        return JsonUtils.MAPPER
                .convertValue(collectionSerpDataMap, CollectionSerpData.class)
                .withNormalizedJson(JsonUtils.toDeterministicJson(collectionSerpDataMap));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CollectionSerpData that = (CollectionSerpData) o;
        return cardsCount == that.cardsCount &&
                Objects.equals(name, that.name) &&
                Objects.equals(url, that.url) &&
                Objects.equals(thumbId, that.thumbId) &&
                Objects.equals(items, that.items) &&
                Objects.equals(id, that.id) &&
                Objects.equals(normalizedJson, that.normalizedJson);
    }

    @Override
    public int hashCode() {
        return Objects.hash(name, url, thumbId, cardsCount, items, id, normalizedJson);
    }
}
