package ru.yandex.direct.libs.collections.model.serpdata;

import java.util.List;
import java.util.Objects;

import org.asynchttpclient.Response;

import ru.yandex.direct.asynchttp.ErrorResponseWrapperException;
import ru.yandex.direct.asynchttp.Result;
import ru.yandex.direct.utils.CollectionUtils;

import static java.net.HttpURLConnection.HTTP_NOT_FOUND;

public class CollectionSerpDataResult {

    private CollectionSerpData collectionSerpData;
    private Throwable error;

    public CollectionSerpDataResult(CollectionSerpData collectionSerpData) {
        this(collectionSerpData, null);
    }

    public CollectionSerpDataResult(CollectionSerpData collectionSerpData, List<Throwable> errors) {
        this.collectionSerpData = collectionSerpData;
        // Нам нужно отличать ошибку недоступности ресурса (404) от всех остальных ошибок. Для этого достаточно 1
        // инстанса,
        // остальные ошибки должны быть идентичны.
        this.error = CollectionUtils.isEmpty(errors) ? null : errors.get(0);
    }

    public static CollectionSerpDataResult ofResponse(Result<CollectionSerpData> result) {
        return new CollectionSerpDataResult(result.getSuccess(), result.getErrors());
    }

    public CollectionSerpData getCollectionSerpData() {
        return collectionSerpData;
    }

    public Throwable getError() {
        return error;
    }

    public boolean isSuccessfulResult() {
        return collectionSerpData != null;
    }

    public boolean isCollectionNotFoundResult() {
        if (isSuccessfulResult()) {
            return false;
        }
        if (!(error instanceof ErrorResponseWrapperException)) {
            return false;
        }

        ErrorResponseWrapperException exception = (ErrorResponseWrapperException) error;
        Response response = exception.getResponse();

        return response != null && response.getStatusCode() == HTTP_NOT_FOUND;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        CollectionSerpDataResult that = (CollectionSerpDataResult) o;
        return Objects.equals(collectionSerpData, that.collectionSerpData) &&
                Objects.equals(error, that.error);
    }

    @Override
    public int hashCode() {
        return Objects.hash(collectionSerpData, error);
    }

    @Override
    public String toString() {
        return "CollectionSerpDataResult{" +
                "collectionSerpData=" + collectionSerpData +
                ", error=" + error +
                '}';
    }
}
