package ru.yandex.direct.libs.collections.model.serpdata;

import java.util.Objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;

@JsonPropertyOrder(alphabetic = true)
public class Item {

    @JsonProperty("url")
    private String url;

    @JsonProperty("text")
    private String text;

    @JsonProperty("pos")
    private Integer pos;

    @JsonProperty("image_src")
    private String imageSrc;

    @JsonProperty("card_id")
    private String cardId;

    public String getUrl() {
        return url;
    }

    public String getText() {
        return text;
    }

    public Integer getPos() {
        return pos;
    }

    public String getImageSrc() {
        return imageSrc;
    }

    public String getCardId() {
        return cardId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item) o;
        return Objects.equals(url, item.url) &&
                Objects.equals(text, item.text) &&
                Objects.equals(pos, item.pos) &&
                Objects.equals(imageSrc, item.imageSrc) &&
                Objects.equals(cardId, item.cardId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(url, text, pos, imageSrc, cardId);
    }
}
