JDK_VERSION(11)

LINT(strict)

NEED_CHECK()

INCLUDE(${KOTLIN_BOM_FILE})
WITH_KOTLINC_ALLOPEN(preset=spring)

EXCLUDE (
    contrib/java/org/slf4j/slf4j-log4j12
    contrib/java/log4j/log4j/1.2.17
    contrib/java/com/google/code/findbugs/annotations/2.0.1
    contrib/java/com/google/protobuf/protobuf-javalite
    contrib/java/javax/activation/activation/1.1.1
    contrib/java/javax/activation/activation/1.1

    contrib/java/org/hamcrest/hamcrest-core/1.1
    contrib/java/org/hamcrest/hamcrest-all/1.1
    contrib/java/org/mockito/mockito-core/1.9.5

    contrib/java/commons-beanutils/commons-beanutils-core/1.8.3

    contrib/java/org/springframework/spring-test/4.3.2.RELEASE
    contrib/java/org/springframework/spring-aop/4.2.5.RELEASE

    contrib/java/javax/servlet/servlet-api/2.3
    contrib/java/javax/servlet/servlet-api/2.4
    contrib/java/javax/servlet/servlet-api/2.5

    contrib/java/org/ow2/asm/asm-all/5.0.2
    contrib/java/org/ow2/asm/asm-all/5.0.3

    contrib/java/com/graphql-java/java-dataloader/2.0.1
    contrib/java/com/ning/async-http-client/1.9.33
    contrib/java/net/jpountz/lz4/lz4

    contrib/java/com/vaadin/external/google/android-json
    contrib/java/io/netty/netty-tcnative-boringssl-static

    devtools/junit-runner
)

JVM_ARGS(
    # java-8 не должна падать от опций java-9
    -XX:+IgnoreUnrecognizedVMOptions
    --illegal-access=warn
)

SET(guava_version 27.0-jre)
SET(jersey_version 2.23.1)
SET(apache_http_version 4.4.1)
SET(netty_version 4.1.63.Final)
SET(netty_epoll_linux_version 4.1.63.Final)
SET(async_http_client_version 2.12.3)
SET(jackson_version 2.9.7)
SET(curator_version 4.2.0)

SET(jooq_version 3.12.1)
SET(jetty_version 9.4.45.v20220203)
SET(slf4j_version 1.7.25)
SET(log4j_version 2.17.1)

SET(assertj_version 3.21.0)
SET(mockito_version 3.6.28)
SET(byte_buddy_version 1.10.22)
SET(junitparams_version 1.0.6)
SET(json_unit_version 1.31.0)

SET(spring_security_version 5.6.2)
SET(spring_version 5.3.18)
SET(spring_retry_version 1.2.0.RELEASE)
SET(spring_boot_version 2.2.8.RELEASE)
SET(swagger_version 2.6.1)
SET(apache_poi_version 3.17)
SET(asm_version 7.0)
SET(archunit_version 0.23.1)

SET(junit5_jupiter_version 5.5.2) # should depend on spring_boot_version

INCLUDE(${ARCADIA_ROOT}/contrib/java/org/junit/junit-bom/${junit5_jupiter_version}/junit-bom.bom.inc)
DEPENDENCY_MANAGEMENT(
    contrib/java/com/google/guava/guava/${guava_version}
    contrib/java/com/google/code/findbugs/jsr305/3.0.2
    contrib/java/com/google/re2j/re2j/1.2
    contrib/java/com/google/truth/extensions/truth-proto-extension/0.34
    contrib/java/javax/annotation/javax.annotation-api/1.3.1
    contrib/java/org/jetbrains/annotations/19.0.0
    contrib/java/one/util/streamex/0.7.0
    contrib/java/com/typesafe/config/1.4.0
    contrib/java/com/beust/jcommander/1.64
    contrib/java/org/reactivestreams/reactive-streams/1.0.2

    contrib/java/org/apache/httpcomponents/httpclient/${apache_http_version}
    contrib/java/org/apache/httpcomponents/httpmime/${apache_http_version}
    contrib/java/org/apache/httpcomponents/httpcore-nio/${apache_http_version}
    contrib/java/org/apache/httpcomponents/httpcore/${apache_http_version}
    contrib/java/org/apache/httpcomponents/httpasyncclient/4.1.4

    contrib/java/org/asynchttpclient/async-http-client/${async_http_client_version}
    contrib/java/org/asynchttpclient/async-http-client-netty-utils/${async_http_client_version}

    contrib/java/org/glassfish/jersey/core/jersey-client/${jersey_version}
    contrib/java/org/glassfish/jersey/media/jersey-media-json-jackson/${jersey_version}
    contrib/java/org/glassfish/jersey/media/jersey-media-multipart/${jersey_version}

    contrib/java/io/netty/netty-buffer/${netty_version}
    contrib/java/io/netty/netty-codec/${netty_version}
    contrib/java/io/netty/netty-codec-http/${netty_version}
    contrib/java/io/netty/netty-common/${netty_version}
    contrib/java/io/netty/netty-handler/${netty_version}
    contrib/java/io/netty/netty-transport/${netty_version}
    contrib/java/io/netty/netty-transport-native-epoll-linux-x86_64/${netty_epoll_linux_version}
    contrib/java/io/netty/netty-codec-http2/${netty_version}
    contrib/java/io/netty/netty-codec-socks/${netty_version}
    contrib/java/io/netty/netty-handler-proxy/${netty_version}
    contrib/java/io/netty/netty-resolver/${netty_version}

    contrib/java/io/grpc/grpc-core/1.43.2
    contrib/java/io/grpc/grpc-netty-shaded/1.43.2
    contrib/java/io/grpc/grpc-netty/1.43.2
    contrib/java/io/grpc/grpc-protobuf/1.43.2
    contrib/java/io/grpc/grpc-stub/1.43.2

    contrib/java/commons-collections/commons-collections/3.2.2
    contrib/java/org/apache/commons/commons-collections4/4.3
    contrib/java/commons-codec/commons-codec/1.10
    contrib/java/commons-io/commons-io/2.5
    contrib/java/commons-beanutils/commons-beanutils/1.9.3
    contrib/java/commons-logging/commons-logging/1.2

    contrib/java/joda-time/joda-time/2.9.9

    contrib/java/org/freemarker/freemarker/2.3.30

    contrib/java/org/apache/poi/poi/${apache_poi_version}
    contrib/java/org/apache/poi/poi-ooxml/${apache_poi_version}
    contrib/java/com/amazonaws/aws-java-sdk-s3/1.11.179
    contrib/java/org/apache/commons/commons-math3/3.5
    contrib/java/org/apache/commons/commons-lang3/3.4
    contrib/java/commons-lang/commons-lang/2.6
    contrib/java/commons-validator/commons-validator/1.6
    contrib/java/org/antlr/antlr-runtime/3.5.2
    contrib/java/org/antlr/antlr4-runtime/4.7.1
    contrib/java/org/antlr/antlr4/4.7.1
    contrib/java/it/unimi/dsi/fastutil/8.4.1

    contrib/java/org/objenesis/objenesis/2.5
    contrib/java/com/sun/activation/javax.activation/1.2.0
    contrib/java/com/fasterxml/classmate/1.3.1

    contrib/java/javax/xml/ws/jaxws-api/2.3.1
    contrib/java/javax/xml/bind/jaxb-api/2.3.1

    contrib/java/com/sun/xml/ws/jaxws-ri/2.3.2
    contrib/java/org/glassfish/jaxb/jaxb-runtime/2.3.2

    contrib/java/org/jdom/jdom/1.1
    contrib/java/com/fasterxml/woodstox/woodstox-core/5.0.3
    contrib/java/xalan/xalan/2.7.2
    contrib/java/xml-apis/xml-apis/1.3.04
    contrib/java/org/apache/xmlgraphics/fop/2.3
    contrib/java/com/fasterxml/jackson/jaxrs/jackson-jaxrs-base/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-annotations/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-core/${jackson_version}
    contrib/java/com/fasterxml/jackson/core/jackson-databind/${jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-cbor/${jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-xml/${jackson_version}
    contrib/java/com/fasterxml/jackson/dataformat/jackson-dataformat-yaml/${jackson_version}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-guava/${jackson_version}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jsr310/${jackson_version}
    contrib/java/com/fasterxml/jackson/module/jackson-module-jaxb-annotations/${jackson_version}
    contrib/java/com/fasterxml/jackson/datatype/jackson-datatype-jdk8/${jackson_version}
    contrib/java/com/fasterxml/jackson/module/jackson-module-kotlin/${jackson_version}
    contrib/java/com/google/code/gson/gson/2.8.6
    contrib/java/org/jsoup/jsoup/1.12.1

    contrib/java/org/reflections/reflections/0.9.10
    contrib/java/org/codehaus/woodstox/stax2-api/3.1.4

    contrib/java/javax/servlet/javax.servlet-api/3.1.0

    contrib/java/io/springfox/springfox-swagger-ui/${swagger_version}
    contrib/java/io/springfox/springfox-swagger2/${swagger_version}
    contrib/java/io/swagger/swagger-annotations/1.5.10

    contrib/java/org/springframework/retry/spring-retry/${spring_retry_version}

    contrib/java/org/springframework/security/spring-security-config/${spring_security_version}
    contrib/java/org/springframework/security/spring-security-core/${spring_security_version}
    contrib/java/org/springframework/security/spring-security-web/${spring_security_version}

    contrib/java/org/springframework/spring-aop/${spring_version}
    contrib/java/org/springframework/spring-beans/${spring_version}
    contrib/java/org/springframework/spring-context/${spring_version}
    contrib/java/org/springframework/spring-context-support/${spring_version}
    contrib/java/org/springframework/spring-core/${spring_version}
    contrib/java/org/springframework/spring-jdbc/${spring_version}
    contrib/java/org/springframework/spring-oxm/${spring_version}
    contrib/java/org/springframework/spring-test/${spring_version}
    contrib/java/org/springframework/spring-tx/${spring_version}
    contrib/java/org/springframework/spring-web/${spring_version}
    contrib/java/org/springframework/spring-webmvc/${spring_version}
    contrib/java/org/springframework/spring-expression/${spring_version}

    contrib/java/org/springframework/boot/spring-boot/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-autoconfigure/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-aop/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-jetty/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-json/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-starter-web/${spring_boot_version}
    contrib/java/org/springframework/data/spring-data-mongodb/2.2.8.RELEASE
    contrib/java/org/mongodb/mongo-java-driver/3.8.2

    contrib/java/org/springframework/boot/spring-boot-test-autoconfigure/${spring_boot_version}
    contrib/java/org/springframework/boot/spring-boot-test/${spring_boot_version}

    contrib/java/org/eclipse/jetty/jetty-server/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-http/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-util/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-io/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-webapp/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-xml/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-servlet/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-security/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-jmx/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-servlets/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-continuation/${jetty_version}
    contrib/java/org/eclipse/jetty/websocket/websocket-server/${jetty_version}
    contrib/java/org/eclipse/jetty/websocket/websocket-common/${jetty_version}
    contrib/java/org/eclipse/jetty/websocket/websocket-api/${jetty_version}
    contrib/java/org/eclipse/jetty/websocket/websocket-client/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-client/${jetty_version}
    contrib/java/org/eclipse/jetty/websocket/websocket-servlet/${jetty_version}
    contrib/java/org/eclipse/jetty/websocket/javax-websocket-server-impl/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-annotations/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-plus/${jetty_version}
    contrib/java/org/eclipse/jetty/jetty-jndi/${jetty_version}
    contrib/java/org/eclipse/jetty/websocket/javax-websocket-client-impl/${jetty_version}

    contrib/java/org/slf4j/slf4j-api/${slf4j_version}
    contrib/java/org/slf4j/slf4j-simple/${slf4j_version}
    contrib/java/org/slf4j/jul-to-slf4j/${slf4j_version}

    contrib/java/org/apache/logging/log4j/log4j-api/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-core/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-jcl/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-1.2-api/${log4j_version}
    contrib/java/org/apache/logging/log4j/log4j-slf4j-impl/${log4j_version}

    contrib/java/org/javassist/javassist/3.18.2-GA
    contrib/java/org/skyscreamer/jsonassert/1.4.0
    contrib/java/com/squareup/javapoet/1.10.0

    contrib/java/org/jooq/jooq/${jooq_version}
    contrib/java/org/jooq/jooq-codegen/${jooq_version}
    contrib/java/org/jooq/jooq-meta-extensions/${jooq_version}

    contrib/java/ru/yandex/geobase/http-geobase/1.3
    contrib/java/ru/yandex/clickhouse/clickhouse-jdbc/0.1.54
    contrib/java/com/github/shyiko/mysql-binlog-connector-java/0.15.0
    contrib/java/mysql/mysql-connector-java/8.0.19
    contrib/java/com/h2database/h2/1.4.195
    contrib/java/com/zaxxer/HikariCP/3.2.0

    contrib/java/redis/clients/jedis/2.9.0
    # используется в jedis
    contrib/java/org/apache/commons/commons-pool2/2.4.3
    contrib/java/io/lettuce/lettuce-core/5.0.4.RELEASE

    contrib/java/org/apache/curator/curator-framework/${curator_version}
    contrib/java/org/apache/curator/curator-client/${curator_version}
    contrib/java/org/apache/curator/curator-recipes/${curator_version}
    contrib/java/org/apache/curator/curator-test/2.12.0
    contrib/java/org/apache/zookeeper/zookeeper/3.4.12

    contrib/java/org/openjdk/jmh/jmh-core/1.19
    contrib/java/org/openjdk/jmh/jmh-generator-annprocess/1.19

    contrib/java/org/hamcrest/hamcrest-all/1.3
    contrib/java/org/hamcrest/hamcrest-core/1.3
    contrib/java/junit/junit/4.12
    contrib/java/pl/pragmatists/JUnitParams/${junitparams_version}
    contrib/java/org/assertj/assertj-core/${assertj_version}
    contrib/java/org/mockito/mockito-core/${mockito_version}
    contrib/java/org/mockito/mockito-junit-jupiter/${mockito_version}
    contrib/java/com/nhaarman/mockitokotlin2/mockito-kotlin/2.2.0
    contrib/java/com/tngtech/archunit/archunit/${archunit_version}
    contrib/java/com/tngtech/archunit/archunit-junit4/${archunit_version}
    contrib/java/com/tngtech/archunit/archunit-junit5-api/${archunit_version}
    contrib/java/com/tngtech/archunit/archunit-junit5-engine/${archunit_version}
    contrib/java/com/tngtech/archunit/archunit-junit5-engine-api/${archunit_version}
    contrib/java/net/bytebuddy/byte-buddy-agent/${byte_buddy_version}
    contrib/java/net/bytebuddy/byte-buddy/${byte_buddy_version}
    contrib/java/ru/yandex/autotests/irt/bean-differ/1.0.1
    contrib/java/io/qameta/allure/allure-java-commons/2.12.1
    contrib/java/io/qameta/allure/allure2-model-api/1.0-BETA6
    contrib/java/io/qameta/allure/allure2-model-pojo/1.0-BETA6
    contrib/java/ru/yandex/qatools/allure/allure-java-annotations/1.4.22
    contrib/java/ru/yandex/aqua/aqua-annotations/2.5.1
    contrib/java/eu/monniot/redis/embedded-redis/1.6.0
    contrib/java/de/flapdoodle/embed/de.flapdoodle.embed.mongo/2.2.0

    contrib/java/net/javacrumbs/json-unit/json-unit-core/${json_unit_version}
    contrib/java/net/javacrumbs/json-unit/json-unit-fluent/${json_unit_version}
    contrib/java/net/javacrumbs/json-unit/json-unit-json-path/${json_unit_version}
    contrib/java/net/javacrumbs/json-unit/json-unit-spring/${json_unit_version}
    contrib/java/com/jayway/jsonpath/json-path/2.2.0

    contrib/java/org/ow2/asm/asm/${asm_version}
    contrib/java/org/ow2/asm/asm-commons/${asm_version}
    contrib/java/org/ow2/asm/asm-tree/${asm_version}

    contrib/java/org/aspectj/aspectjrt/1.9.0
    contrib/java/org/aspectj/aspectjweaver/1.9.0

    contrib/java/com/squareup/okhttp3/mockwebserver/3.3.1

    contrib/java/net/minidev/accessors-smart/1.2
    contrib/java/com/sun/mail/javax.mail/1.5.6
    contrib/java/org/bouncycastle/bcprov-jdk15on/1.58
    contrib/java/commonj/sdo/commonj.sdo/2.1.1.v201112051852

    # binlogbroker
    contrib/java/org/apache/commons/commons-compress/1.11
    contrib/java/org/tukaani/xz/1.5

    # GraphQL
    contrib/java/com/graphql-java/java-dataloader/2.2.3
    contrib/java/com/graphql-java/graphql-java/16.2
    contrib/java/patched/io/leangen/graphql/spqr/0.11.2-patched

    contrib/java/javax/el/javax.el-api/2.2.4
    contrib/java/org/glassfish/web/javax.el/2.2.4
    contrib/java/javax/validation/validation-api/2.0.1.Final
    contrib/java/org/hibernate/hibernate-validator/5.4.0.Final

    contrib/java/com/googlecode/libphonenumber/libphonenumber/8.10.2

    contrib/java/com/github/spullara/mustache/java/compiler/0.9.6
    contrib/java/org/thymeleaf/thymeleaf/3.0.11.RELEASE

    contrib/java/org/awaitility/awaitility/3.1.6
    contrib/java/org/lz4/lz4-java/1.7.1
)
