INCLUDE(${ARCADIA_ROOT}/direct/libs/common_ut.inc)

IF(MODULE_TYPE == "JUNIT5")
    PEERDIR(
        contrib/java/org/junit/jupiter/junit-jupiter-api
        contrib/java/org/junit/jupiter/junit-jupiter-engine
        contrib/java/org/junit/jupiter/junit-jupiter-params
        contrib/java/org/junit/platform/junit-platform-commons
        contrib/java/org/junit/platform/junit-platform-engine
        contrib/java/org/junit/platform/junit-platform-launcher
        contrib/java/org/junit/platform/junit-platform-suite-api

        contrib/java/org/assertj/assertj-core
        contrib/java/org/mockito/mockito-core
        contrib/java/org/mockito/mockito-junit-jupiter

        devtools/junit5-runner

        direct/libs/test-utils
    )

    IF(HAS_JUNIT4_TESTS == true)
        PEERDIR(
            contrib/java/junit/junit
            contrib/java/org/junit/vintage/junit-vintage-engine
        )
    ELSE()
        EXCLUDE(
            contrib/java/org/junit/vintage/junit-vintage-engine
            contrib/java/junit/junit
            devtools/junit-runner
        )
    ENDIF()
ELSE()
    EXCLUDE(
        contrib/java/org/junit/jupiter/junit-jupiter-api
        contrib/java/org/junit/platform/junit-platform-launcher
        devtools/junit5-runner
    )

    PEERDIR(
        devtools/junit-runner
        contrib/java/junit/junit
        direct/libs/test-utils
    )
ENDIF()

IF(allure_enabled)
    PEERDIR(
        contrib/java/io/qameta/allure/allure-junit5/2.12.1
        contrib/java/org/aspectj/aspectjweaver/1.9.7
    )

    JVM_ARGS(
        -Dallure.results.directory=allure
        -javaagent:${ARCADIA_BUILD_ROOT}/contrib/java/org/aspectj/aspectjweaver/1.9.7/aspectjweaver-1.9.7.jar
    )
ENDIF()
