package ru.yandex.direct.communication.container;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

import ru.yandex.direct.core.entity.campaign.model.Campaign;
import ru.yandex.direct.currency.Currency;
import ru.yandex.direct.currency.Percent;
import ru.yandex.direct.dbutil.model.ClientId;

/**
 *
 * Контейнер с информацией о том к какому объекту необходимо применить набор событий/рекомендаций
 */
public class AdditionalInfoContainer {
    private Optional<Integer> shard;
    private Function<AdditionalInfoContainer, Integer> shardSupplier;

    private Optional<ClientId> clientId;
    private Function<AdditionalInfoContainer, ClientId> clientIdSupplier;

    private Optional<Long> clientUid;
    private Function<AdditionalInfoContainer, Long> clientUidSupplier;

    private Optional<Percent> nds;
    private Function<AdditionalInfoContainer, Percent> ndsSupplier;

    private Optional<Long> userId;
    private Function<AdditionalInfoContainer, Long> userIdSupplier;

    private Optional<Long> requestId;
    private Function<AdditionalInfoContainer, Long> requestIdSupplier;

    private Optional<String> language;
    private Function<AdditionalInfoContainer, String> languageSupplier;

    private Optional<Long> currentTimeStamp;
    private Function<AdditionalInfoContainer, Long> currentTimeStampSupplier;

    private Optional<Map<Long, Set>> cookieAddedStatusesByMessageId;
    private Function<AdditionalInfoContainer, Map<Long, Set>> cookieAddedStatusesByMessageIdSupplier;

    private Optional<Map<Long, Set>> cookieRemovedStatusesByMessageId;
    private Function<AdditionalInfoContainer, Map<Long, Set>> cookieRemovedStatusesByMessageIdSupplier;

    private Optional<String> clientLogin;
    private Function<AdditionalInfoContainer, String> clientLoginSupplier;

    private Optional<String> clientName;
    private Function<AdditionalInfoContainer, String> clientNameSupplier;

    private Optional<String> clientEmail;
    private Function<AdditionalInfoContainer, String> clientEmailSupplier;

    private Optional<String> userLogin;
    private Function<AdditionalInfoContainer, String> userLoginSupplier;

    private Optional<Boolean> canUserWrite;
    private Function<AdditionalInfoContainer, Boolean> canUserWriteSupplier;

    private Optional<Currency> currency;
    private Function<AdditionalInfoContainer, Currency> currencySupplier;

    private Optional<List<String>> enabledFeatures;
    private Function<AdditionalInfoContainer, List<String>> enabledFeaturesSupplier;

    private Optional<List<Long>> testIds;
    private Function<AdditionalInfoContainer, List<Long>> testIdsSupplier;

    private Optional<Map<String, Object>> abstractInfo;
    private Function<AdditionalInfoContainer, Map<String, Object>> abstractInfoSupplier;

    private Optional<Map<String, String>> params;
    private Function<AdditionalInfoContainer, Map<String, String>> paramsSupplier;

    private Optional<Map<Long, Campaign>> contextCampaigns;
    private Function<AdditionalInfoContainer, Map<Long, Campaign>> contextCampaignsSupplier;

    public Optional<Integer> getShard() {
        if(shard == null) {
            shard = shardSupplier == null ? Optional.empty() : Optional.ofNullable(shardSupplier.apply(this));
        }
        return shard;
    }

    public AdditionalInfoContainer withShard(Integer shard) {
        this.shard = Optional.ofNullable(shard);
        return this;
    }

    public AdditionalInfoContainer withShardSupplier(
            Function<AdditionalInfoContainer, Integer> shardSupplier) {
        this.shardSupplier = shardSupplier;
        return this;
    }

    public Optional<ClientId> getClientId() {
        if(clientId == null) {
            clientId = clientIdSupplier == null ? Optional.empty() : Optional.ofNullable(clientIdSupplier.apply(this));
        }
        return clientId;
    }

    public AdditionalInfoContainer withClientId(ClientId clientId) {
        this.clientId = Optional.ofNullable(clientId);
        return this;
    }

    public AdditionalInfoContainer withClientIdSupplier(
            Function<AdditionalInfoContainer, ClientId> clientIdSupplier) {
        this.clientIdSupplier = clientIdSupplier;
        return this;
    }

    public Optional<Long> getClientUid() {
        if(clientUid == null) {
            clientUid = clientUidSupplier == null ? Optional.empty() : Optional.ofNullable(clientUidSupplier.apply(this));
        }
        return clientUid;
    }

    public AdditionalInfoContainer withClientUid(Long clientUid) {
        this.clientUid = Optional.ofNullable(clientUid);
        return this;
    }

    public AdditionalInfoContainer withClientUidSupplier(
            Function<AdditionalInfoContainer, Long> clientUidSupplier) {
        this.clientUidSupplier = clientUidSupplier;
        return this;
    }

    public Optional<Percent> getNds() {
        if(nds == null) {
            nds = ndsSupplier == null ? Optional.empty() : Optional.ofNullable(ndsSupplier.apply(this));
        }
        return nds;
    }

    public AdditionalInfoContainer withNds(Percent nds) {
        this.nds = Optional.ofNullable(nds);
        return this;
    }

    public AdditionalInfoContainer withNdsSupplier(
            Function<AdditionalInfoContainer, Percent> ndsSupplier) {
        this.ndsSupplier = ndsSupplier;
        return this;
    }

    public Optional<Long> getUserId() {
        if(userId == null) {
            userId = userIdSupplier == null ? Optional.empty() : Optional.ofNullable(userIdSupplier.apply(this));
        }
        return userId;
    }

    public AdditionalInfoContainer withUserId(Long userId) {
        this.userId = Optional.ofNullable(userId);
        return this;
    }

    public AdditionalInfoContainer withUserIdSupplier(
            Function<AdditionalInfoContainer, Long> userIdSupplier) {
        this.userIdSupplier = userIdSupplier;
        return this;
    }

    public Optional<Long> getRequestId() {
        if(requestId == null) {
            requestId = requestIdSupplier == null ? Optional.empty() : Optional.ofNullable(requestIdSupplier.apply(this));
        }
        return requestId;
    }

    public AdditionalInfoContainer withRequestId(Long requestId) {
        this.requestId = Optional.ofNullable(requestId);
        return this;
    }

    public AdditionalInfoContainer withRequestIdSupplier(
            Function<AdditionalInfoContainer, Long> requestIdSupplier) {
        this.requestIdSupplier = requestIdSupplier;
        return this;
    }

    public Optional<String> getLanguage() {
        if(language == null) {
            language = languageSupplier == null ? Optional.empty() : Optional.ofNullable(languageSupplier.apply(this));
        }
        return language;
    }

    public AdditionalInfoContainer withLanguage(String language) {
        this.language = Optional.ofNullable(language);
        return this;
    }

    public AdditionalInfoContainer withLanguageSupplier(
            Function<AdditionalInfoContainer, String> languageSupplier) {
        this.languageSupplier = languageSupplier;
        return this;
    }

    public Optional<Long> getCurrentTimeStamp() {
        if(currentTimeStamp == null) {
            currentTimeStamp = currentTimeStampSupplier == null ? Optional.empty() : Optional.ofNullable(currentTimeStampSupplier.apply(this));
        }
        return currentTimeStamp;
    }

    public AdditionalInfoContainer withCurrentTimeStamp(Long currentTimeStamp) {
        this.currentTimeStamp = Optional.ofNullable(currentTimeStamp);
        return this;
    }

    public AdditionalInfoContainer withCurrentTimeStampSupplier(
            Function<AdditionalInfoContainer, Long> currentTimeStampSupplier) {
        this.currentTimeStampSupplier = currentTimeStampSupplier;
        return this;
    }

    public Optional<Map<Long, Set>> getCookieAddedStatusesByMessageId() {
        if(cookieAddedStatusesByMessageId == null) {
            cookieAddedStatusesByMessageId = cookieAddedStatusesByMessageIdSupplier == null ? Optional.empty() : Optional.ofNullable(cookieAddedStatusesByMessageIdSupplier.apply(this));
        }
        return cookieAddedStatusesByMessageId;
    }

    public AdditionalInfoContainer withCookieAddedStatusesByMessageId(Map<Long, Set> cookieAddedStatusesByMessageId) {
        this.cookieAddedStatusesByMessageId = Optional.ofNullable(cookieAddedStatusesByMessageId);
        return this;
    }

    public AdditionalInfoContainer withCookieAddedStatusesByMessageIdSupplier(
            Function<AdditionalInfoContainer, Map<Long, Set>> cookieAddedStatusesByMessageIdSupplier) {
        this.cookieAddedStatusesByMessageIdSupplier = cookieAddedStatusesByMessageIdSupplier;
        return this;
    }

    public Optional<Map<Long, Set>> getCookieRemovedStatusesByMessageId() {
        if(cookieRemovedStatusesByMessageId == null) {
            cookieRemovedStatusesByMessageId = cookieRemovedStatusesByMessageIdSupplier == null ? Optional.empty() : Optional.ofNullable(cookieRemovedStatusesByMessageIdSupplier.apply(this));
        }
        return cookieRemovedStatusesByMessageId;
    }

    public AdditionalInfoContainer withCookieRemovedStatusesByMessageId(Map<Long, Set> cookieRemovedStatusesByMessageId) {
        this.cookieRemovedStatusesByMessageId = Optional.ofNullable(cookieRemovedStatusesByMessageId);
        return this;
    }

    public AdditionalInfoContainer withCookieRemovedStatusesByMessageIdSupplier(
            Function<AdditionalInfoContainer, Map<Long, Set>> cookieRemovedStatusesByMessageIdSupplier) {
        this.cookieRemovedStatusesByMessageIdSupplier = cookieRemovedStatusesByMessageIdSupplier;
        return this;
    }

    public Optional<String> getClientLogin() {
        if(clientLogin == null) {
            clientLogin = clientLoginSupplier == null ? Optional.empty() : Optional.ofNullable(clientLoginSupplier.apply(this));
        }
        return clientLogin;
    }

    public AdditionalInfoContainer withClientLogin(String clientLogin) {
        this.clientLogin = Optional.ofNullable(clientLogin);
        return this;
    }

    public AdditionalInfoContainer withClientLoginSupplier(
            Function<AdditionalInfoContainer, String> clientLoginSupplier) {
        this.clientLoginSupplier = clientLoginSupplier;
        return this;
    }

    public Optional<String> getClientName() {
        if(clientName == null) {
            clientName = clientNameSupplier == null ? Optional.empty() : Optional.ofNullable(clientNameSupplier.apply(this));
        }
        return clientName;
    }

    public AdditionalInfoContainer withClientName(String clientName) {
        this.clientName = Optional.ofNullable(clientName);
        return this;
    }

    public AdditionalInfoContainer withClientNameSupplier(
            Function<AdditionalInfoContainer, String> clientNameSupplier) {
        this.clientNameSupplier = clientNameSupplier;
        return this;
    }

    public Optional<String> getClientEmail() {
        if(clientEmail == null) {
            clientEmail = clientEmailSupplier == null ? Optional.empty() : Optional.ofNullable(clientEmailSupplier.apply(this));
        }
        return clientEmail;
    }

    public AdditionalInfoContainer withClientEmail(String clientEmail) {
        this.clientEmail = Optional.ofNullable(clientEmail);
        return this;
    }

    public AdditionalInfoContainer withClientEmailSupplier(
            Function<AdditionalInfoContainer, String> clientEmailSupplier) {
        this.clientEmailSupplier = clientEmailSupplier;
        return this;
    }

    public Optional<String> getUserLogin() {
        if(userLogin == null) {
            userLogin = userLoginSupplier == null ? Optional.empty() : Optional.ofNullable(userLoginSupplier.apply(this));
        }
        return userLogin;
    }

    public AdditionalInfoContainer withUserLogin(String userLogin) {
        this.userLogin = Optional.ofNullable(userLogin);
        return this;
    }

    public AdditionalInfoContainer withUserLoginSupplier(
            Function<AdditionalInfoContainer, String> userLoginSupplier) {
        this.userLoginSupplier = userLoginSupplier;
        return this;
    }

    public Optional<Boolean> getCanUserWrite() {
        if(canUserWrite == null) {
            canUserWrite = canUserWriteSupplier == null ? Optional.empty() : Optional.ofNullable(canUserWriteSupplier.apply(this));
        }
        return canUserWrite;
    }

    public AdditionalInfoContainer withCanUserWrite(Boolean canUserWrite) {
        this.canUserWrite = Optional.ofNullable(canUserWrite);
        return this;
    }

    public AdditionalInfoContainer withCanUserWriteSupplier(
            Function<AdditionalInfoContainer, Boolean> canUserWriteSupplier) {
        this.canUserWriteSupplier = canUserWriteSupplier;
        return this;
    }

    public Optional<Currency> getCurrency() {
        if(currency == null) {
            currency = currencySupplier == null ? Optional.empty() : Optional.ofNullable(currencySupplier.apply(this));
        }
        return currency;
    }

    public AdditionalInfoContainer withCurrency(Currency currency) {
        this.currency = Optional.ofNullable(currency);
        return this;
    }

    public AdditionalInfoContainer withCurrencySupplier(
            Function<AdditionalInfoContainer, Currency> currencySupplier) {
        this.currencySupplier = currencySupplier;
        return this;
    }

    public Optional<List<String>> getEnabledFeatures() {
        if(enabledFeatures == null) {
            enabledFeatures = enabledFeaturesSupplier == null ? Optional.empty() : Optional.ofNullable(enabledFeaturesSupplier.apply(this));
        }
        return enabledFeatures;
    }

    public AdditionalInfoContainer withEnabledFeatures(List<String> enabledFeatures) {
        this.enabledFeatures = Optional.ofNullable(enabledFeatures);
        return this;
    }

    public AdditionalInfoContainer withEnabledFeaturesSupplier(
            Function<AdditionalInfoContainer, List<String>> enabledFeaturesSupplier) {
        this.enabledFeaturesSupplier = enabledFeaturesSupplier;
        return this;
    }

    public Optional<List<Long>> getTestIds() {
        if(testIds == null) {
            testIds = testIdsSupplier == null ? Optional.empty() : Optional.ofNullable(testIdsSupplier.apply(this));
        }
        return testIds;
    }

    public AdditionalInfoContainer withTestIds(List<Long> testIds) {
        this.testIds = Optional.ofNullable(testIds);
        return this;
    }

    public AdditionalInfoContainer withTestIdsSupplier(
            Function<AdditionalInfoContainer, List<Long>> testIdsSupplier) {
        this.testIdsSupplier = testIdsSupplier;
        return this;
    }

    public Optional<Map<String, Object>> getAbstractInfo() {
        if(abstractInfo == null) {
            abstractInfo = abstractInfoSupplier == null ? Optional.empty() : Optional.ofNullable(abstractInfoSupplier.apply(this));
        }
        return abstractInfo;
    }

    public AdditionalInfoContainer withAbstractInfo(Map<String, Object> abstractInfo) {
        this.abstractInfo = Optional.ofNullable(abstractInfo);
        return this;
    }

    public AdditionalInfoContainer withAbstractInfoSupplier(
            Function<AdditionalInfoContainer, Map<String, Object>> abstractInfoSupplier) {
        this.abstractInfoSupplier = abstractInfoSupplier;
        return this;
    }

    public Optional<Map<String, String>> getParams() {
        if(params == null) {
            params = paramsSupplier == null ? Optional.empty() : Optional.ofNullable(paramsSupplier.apply(this));
        }
        return params;
    }

    public AdditionalInfoContainer withParams(Map<String, String> params) {
        this.params = Optional.ofNullable(params);
        return this;
    }

    public AdditionalInfoContainer withParamsSupplier(
            Function<AdditionalInfoContainer, Map<String, String>> paramsSupplier) {
        this.paramsSupplier = paramsSupplier;
        this.params = null;
        return this;
    }

    public Optional<Map<Long, Campaign>> getContextCampaigns() {
        if(contextCampaigns == null) {
            contextCampaigns = contextCampaignsSupplier == null ? Optional.empty() : Optional.ofNullable(contextCampaignsSupplier.apply(this));
        }
        return contextCampaigns;
    }

    public AdditionalInfoContainer withContextCampaigns(Map<Long, Campaign> contextCampaigns) {
        this.contextCampaigns = Optional.ofNullable(contextCampaigns);
        return this;
    }

    public AdditionalInfoContainer withContextCampaignsSupplier(
            Function<AdditionalInfoContainer, Map<Long, Campaign>> contextCampaignsSupplier) {
        this.contextCampaignsSupplier = contextCampaignsSupplier;
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("ru.yandex.direct.core.entity.communication.model.AdditionalInfoContainer{");
        sb.append("shard=").append(shard);
        sb.append(", clientId=").append(clientId);
        sb.append(", clientUid=").append(clientUid);
        sb.append(", nds=").append(nds);
        sb.append(", userId=").append(userId);
        sb.append(", requestId=").append(requestId);
        sb.append(", language=").append(language);
        sb.append(", currentTimeStamp=").append(currentTimeStamp);
        sb.append(", cookieAddedStatusesByMessageId=").append(cookieAddedStatusesByMessageId);
        sb.append(", cookieRemovedStatusesByMessageId=").append(cookieRemovedStatusesByMessageId);
        sb.append(", clientLogin=").append(clientLogin);
        sb.append(", userLogin=").append(userLogin);
        sb.append(", canUserWrite=").append(canUserWrite);
        sb.append(", currency=").append(currency);
        sb.append(", enabledFeatures=").append(enabledFeatures);
        sb.append(", testIds=").append(testIds);
        sb.append(", abstractInfo=").append(abstractInfo);
        sb.append(", params=").append(params);
        sb.append(", contextCampaigns=").append(contextCampaigns);
        sb.append('}');
        return sb.toString();
    }
}
