package ru.yandex.direct.communication.container.web;

import java.util.List;

import ru.yandex.direct.core.entity.communication.model.EDataType;

public class CommunicationDataContainer {
    private EDataType type;
    private String fieldName;
    private String text;
    private List<CommunicationDataContainer> subData;

    public EDataType getType() {
        return type;
    }

    public CommunicationDataContainer withType(EDataType type) {
        this.type = type;
        return this;
    }

    public String getFieldName() {
        return fieldName;
    }

    public CommunicationDataContainer withFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public String getText() {
        return text;
    }

    public CommunicationDataContainer withText(String text) {
        this.text = text;
        return this;
    }

    public List<CommunicationDataContainer> getSubData() {
        return subData;
    }

    public CommunicationDataContainer withSubData(List<CommunicationDataContainer> subData) {
        this.subData = subData;
        return this;
    }
}
