package ru.yandex.direct.communication.container.web;

import java.util.List;

import ru.yandex.direct.core.entity.communication.model.LinkPath;
import ru.yandex.direct.core.entity.communication.model.TargetEntityType;
import ru.yandex.direct.dbutil.model.ClientId;

public class CommunicationLinkInfo {
    private LinkPath path;
    private TargetEntityType entityType;
    private List<Long> entityIds;
    private Long campaignId;
    private ClientId clientId;

    public LinkPath getPath() {
        return path;
    }

    public CommunicationLinkInfo withPath(LinkPath path) {
        this.path = path;
        return this;
    }

    public TargetEntityType getEntityType() {
        return entityType;
    }

    public CommunicationLinkInfo withEntityType(TargetEntityType entityType) {
        this.entityType = entityType;
        return this;
    }

    public List<Long> getEntityIds() {
        return entityIds;
    }

    public CommunicationLinkInfo withEntityIds(List<Long> entityIds) {
        this.entityIds = entityIds;
        return this;
    }

    public Long getCampaignId() {
        return campaignId;
    }

    public CommunicationLinkInfo withCampaignId(Long campaignId) {
        this.campaignId = campaignId;
        return this;
    }

    public ClientId getClientId() {
        return clientId;
    }

    public CommunicationLinkInfo withClientId(ClientId clientId) {
        this.clientId = clientId;
        return this;
    }
}
