package ru.yandex.direct.communication.container.web;

import java.util.Map;

import ru.yandex.ads.bsyeti.libs.communications.EWebUIMessageStatus;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.core.entity.communication.model.Severity;
import ru.yandex.direct.sender.YandexSenderTemplateParams;

public class CommunicationMessage {

    private Long requestId;
    private Long messageId;
    private Long userId;
    private Long clientId;
    private Slot slot;
    private long eventId;
    private long eventVersionId;
    private String inventoryAdditionalData;
    private String name;
    private String groupName;
    private long majorVersion;
    private long minorVersion;
    private EWebUIMessageStatus status;
    private Severity severity;
    private boolean disableForEdit;
    private CommunicationTargetObject targetObject;
    private CommunicationMessageContent content;
    private YandexSenderTemplateParams mailData;
    private Map<String, Object> data;

    public Long getRequestId() {
        return requestId;
    }

    public CommunicationMessage withRequestId(Long requestId) {
        this.requestId = requestId;
        return this;
    }

    public Long getMessageId() {
        return messageId;
    }

    public CommunicationMessage withMessageId(Long messageId) {
        this.messageId = messageId;
        return this;
    }

    public Long getUserId() {
        return userId;
    }

    public CommunicationMessage withUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public CommunicationMessage withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Slot getSlot() {
        return slot;
    }

    public CommunicationMessage withSlot(Slot slot) {
        this.slot = slot;
        return this;
    }

    public long getEventId() {
        return eventId;
    }

    public CommunicationMessage withEventId(long eventId) {
        this.eventId = eventId;
        return this;
    }

    public long getEventVersionId() {
        return eventVersionId;
    }

    public CommunicationMessage withEventVersionId(long eventVersionId) {
        this.eventVersionId = eventVersionId;
        return this;
    }

    public String getInventoryAdditionalData() {
        return inventoryAdditionalData;
    }

    public CommunicationMessage withInventoryAdditionalData(String inventoryAdditionalData) {
        this.inventoryAdditionalData = inventoryAdditionalData;
        return this;
    }

    public String getName() {
        return name;
    }

    public CommunicationMessage withName(String name) {
        this.name = name;
        return this;
    }

    public String getGroupName() {
        return groupName;
    }

    public CommunicationMessage withGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    public long getMajorVersion() {
        return majorVersion;
    }

    public CommunicationMessage withMajorVersion(long majorVersion) {
        this.majorVersion = majorVersion;
        return this;
    }

    public long getMinorVersion() {
        return minorVersion;
    }

    public CommunicationMessage withMinorVersion(long minorVersion) {
        this.minorVersion = minorVersion;
        return this;
    }

    public Severity getSeverity() {
        return severity;
    }

    public CommunicationMessage withSeverity(Severity severity) {
        this.severity = severity;
        return this;
    }

    public EWebUIMessageStatus getStatus() {
        return status;
    }

    public CommunicationMessage withStatus(EWebUIMessageStatus status) {
        this.status = status;
        return this;
    }

    public boolean isDisableForEdit() {
        return disableForEdit;
    }

    public CommunicationMessage withDisableForEdit(boolean disableForEdit) {
        this.disableForEdit = disableForEdit;
        return this;
    }

    public CommunicationTargetObject getTargetObject() {
        return targetObject;
    }

    public CommunicationMessage withTargetObject(CommunicationTargetObject targetObject) {
        this.targetObject = targetObject;
        return this;
    }

    public CommunicationMessageContent getContent() {
        return content;
    }

    public CommunicationMessage withContent(CommunicationMessageContent content) {
        this.content = content;
        return this;
    }

    public YandexSenderTemplateParams getMailData() {
        return mailData;
    }

    public CommunicationMessage withMailData(YandexSenderTemplateParams mailData) {
        this.mailData = mailData;
        return this;
    }

    public Map<String, Object> getData() {
        return data;
    }

    public CommunicationMessage withData(Map<String, Object> data) {
        this.data = data;
        return this;
    }
}
