package ru.yandex.direct.communication.container.web;

import ru.yandex.ads.bsyeti.libs.communications.EWebUIButtonActionType;
import ru.yandex.ads.bsyeti.libs.communications.EWebUIButtonStyle;
import ru.yandex.direct.core.entity.communication.model.ActionType;
import ru.yandex.direct.core.entity.communication.model.ViewType;

public class CommunicationMessageButton {

    private long id;
    private String title;
    private String confirmText;
    private String href;
    private EWebUIButtonStyle style;
    private EWebUIButtonActionType action;
    private ActionType actionType;
    private ViewType viewType;
    private CommunicationLinkInfo linkInfo;
    private String successTitle;
    private String successText;
    private boolean disabled;

    public long getId() {
        return id;
    }

    public CommunicationMessageButton withId(long id) {
        this.id = id;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public CommunicationMessageButton withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getConfirmText() {
        return confirmText;
    }

    public CommunicationMessageButton withConfirmText(String confirmText) {
        this.confirmText = confirmText;
        return this;
    }

    public String getHref() {
        return href;
    }

    public CommunicationMessageButton withHref(String href) {
        this.href = href;
        return this;
    }

    public EWebUIButtonStyle getStyle() {
        return style;
    }

    public CommunicationMessageButton withStyle(EWebUIButtonStyle style) {
        this.style = style;
        return this;
    }

    public EWebUIButtonActionType getAction() {
        return action;
    }

    public CommunicationMessageButton withAction(EWebUIButtonActionType action) {
        this.action = action;
        return this;
    }

    public ViewType getViewType() {
        return viewType;
    }

    public CommunicationMessageButton withViewType(ViewType viewType) {
        this.viewType = viewType;
        return this;
    }

    public ActionType getActionType() {
        return actionType;
    }

    public CommunicationMessageButton withActionType(ActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public CommunicationLinkInfo getLinkInfo() {
        return linkInfo;
    }

    public CommunicationMessageButton withLinkInfo(CommunicationLinkInfo linkInfo) {
        this.linkInfo = linkInfo;
        return this;
    }

    public String getSuccessTitle() {
        return successTitle;
    }

    public CommunicationMessageButton withSuccessTitle(String successTitle) {
        this.successTitle = successTitle;
        return this;
    }

    public String getSuccessText() {
        return successText;
    }

    public CommunicationMessageButton withSuccessText(String successText) {
        this.successText = successText;
        return this;
    }

    public boolean isDisabled() {
        return disabled;
    }

    public CommunicationMessageButton withDisabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

}
