package ru.yandex.direct.communication.container.web;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

public class CommunicationMessageContent {

    private String title;
    private String text;
    private String imageUrl;
    private List<CommunicationMessageButton> buttons;
    private List<CommunicationMessageInputField> inputFields;
    private CommunicationDataContainer dataContainer;
    private Map<String, String> params;
    private LocalDateTime applyDateTime;

    public String getTitle() {
        return title;
    }

    public CommunicationMessageContent withTitle(String title) {
        this.title = title;
        return this;
    }

    public String getText() {
        return text;
    }

    public CommunicationMessageContent withText(String text) {
        this.text = text;
        return this;
    }

    public String getImageUrl() {
        return imageUrl;
    }

    public CommunicationMessageContent withImageUrl(String imageUrl) {
        this.imageUrl = imageUrl;
        return this;
    }

    public List<CommunicationMessageButton> getButtons() {
        return buttons;
    }

    public CommunicationMessageContent withButtons(List<CommunicationMessageButton> buttons) {
        this.buttons = buttons;
        return this;
    }

    public List<CommunicationMessageInputField> getInputFields() {
        return inputFields;
    }

    public CommunicationMessageContent withInputFields(List<CommunicationMessageInputField> inputFields) {
        this.inputFields = inputFields;
        return this;
    }

    public CommunicationDataContainer getDataContainer() {
        return dataContainer;
    }

    public CommunicationMessageContent withDataContainer(CommunicationDataContainer dataContainer) {
        this.dataContainer = dataContainer;
        return this;
    }

    public Map<String, String> getParams() {
        return params;
    }

    public CommunicationMessageContent withParams(Map<String, String> params) {
        this.params = params;
        return this;
    }

    public LocalDateTime getApplyDateTime() {
        return applyDateTime;
    }

    public CommunicationMessageContent withhApplyDateTime(LocalDateTime applyDateTime) {
        this.applyDateTime = applyDateTime;
        return this;
    }
}
