package ru.yandex.direct.communication.container.web;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.core.entity.communication.model.EValueType;

public class CommunicationMessageInputField {

    private String name;
    private String title;
    private EValueType valueType;
    private String suffix;
    private List<InputValueEnum> availableValues;

    public String getName() {
        return name;
    }

    public CommunicationMessageInputField withName(String name) {
        this.name = name;
        return this;
    }

    public String getTitle() {
        return title;
    }

    public CommunicationMessageInputField withTitle(String title) {
        this.title = title;
        return this;
    }

    public EValueType getValueType() {
        return valueType;
    }

    public CommunicationMessageInputField withValueType(EValueType valueType) {
        this.valueType = valueType;
        return this;
    }

    public String getSuffix() {
        return suffix;
    }

    public CommunicationMessageInputField withSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public List<InputValueEnum> getAvailableValues() {
        return availableValues;
    }

    public CommunicationMessageInputField withAvailableValues(List<InputValueEnum> availableValues) {
        this.availableValues = availableValues;
        return this;
    }

    public static class InputValueEnum {
        private String value;
        private Map<String, Object> params;

        public String getValue() {
            return value;
        }

        public InputValueEnum withValue(String value) {
            this.value = value;
            return this;
        }

        public Map<String, Object> getParams() {
            return params;
        }

        public InputValueEnum withParams(Map<String, Object> params) {
            this.params = params;
            return this;
        }
    }
}
