package ru.yandex.direct.communication.container.web;

import java.util.Objects;

import ru.yandex.direct.communication.model.inventory.ObjectEventData;

public class SlotMessageId {

    public static SlotMessageId of(ObjectEventData objectEventData) {
        return new SlotMessageId(objectEventData.getSlotId(), objectEventData.getMessageId());
    }

    public static SlotMessageId of(CommunicationMessage communicationMessage) {
        return new SlotMessageId(communicationMessage.getSlot().getId(),
                communicationMessage.getMessageId());
    }

    private final Long slotId;
    private final Long messageId;

    private SlotMessageId(Long slotId, Long messageId) {
        this.slotId = slotId;
        this.messageId = messageId;
    }

    public Long getSlotId() {
        return slotId;
    }

    public Long getMessageId() {
        return messageId;
    }

    @Override
    public String toString() {
        return "SlotMessageId{" +
                "slotId=" + slotId +
                ", messageId=" + messageId +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        SlotMessageId that = (SlotMessageId) o;
        return slotId.equals(that.slotId) && messageId.equals(that.messageId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(slotId, messageId);
    }
}
