package ru.yandex.direct.communication.container.web;

import ru.yandex.ads.bsyeti.libs.communications.TDirectWebUIData;

import static ru.yandex.direct.communication.CommunicationHelper.parseWebMessageData;

public class WebMessage {

    private final Message message;
    private final int showAfter;
    private final TDirectWebUIData.EWebUIMessageType messageType;
    private final int priority;

    public WebMessage(Message message, int showAfter, TDirectWebUIData.EWebUIMessageType messageType, int priority) {
        this.message = message;
        this.showAfter = showAfter;
        this.messageType = messageType;
        this.priority = priority;
    }

    public WebMessage(TDirectWebUIData data, Long messageId) {
        message = parseWebMessageData(data, messageId);
        showAfter = data.getShowAfter();
        messageType = data.getMessageType();
        priority = data.getPriority();
    }

    public Message getMessage() {
        return message;
    }

    public int getShowAfter() {
        return showAfter;
    }

    public TDirectWebUIData.EWebUIMessageType getMessageType() {
        return messageType;
    }

    public int getPriority() {
        return priority;
    }
}
