package ru.yandex.direct.communication.facade;

import java.util.List;

import ru.yandex.direct.communication.facade.impl.actions.ActionResultImpl;
import ru.yandex.direct.communication.facade.impl.actions.SubResult;

public interface ActionResult<T extends ActionResult<T>> {

    static ActionResult createSuccess(Long objectId) {
        return new ActionResultImpl(List.of(objectId), List.of());
    }

    static ActionResult createFailed(Long objectId) {
        return new ActionResultImpl(List.of(), List.of(objectId));
    }

    static ActionResult createEmpty() {
        return new ActionResultImpl(List.of(), List.of());
    }

    SummaryActionResult getResult();

    T merge(T second);

    List<Long> getSuccessObjects();

    List<Long> getFailedObjects();

    List<SubResult> getSubResults();
}
