package ru.yandex.direct.communication.facade;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.SlotMessageId;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

public interface ActualChecker {
    /**
     * Проверка актуальности рекомендаций
     * @param messagesData - рекомендации, актуальность которых нужно проверить
     * @param eventVersionByMessageId - версии конфигураций событий
     * @param additionalInfo - дополнительная информация для рассчета
     * @return для каждого события актуально оно или нет
     */
    Map<SlotMessageId, Boolean> check(
            List<ObjectEventData> messagesData,
            Map<SlotMessageId, CommunicationEventVersion> eventVersionByMessageId,
            AdditionalInfoContainer additionalInfo
    );

    /**
     * @return имя проверки
     */
    String getName();
}
