package ru.yandex.direct.communication.facade;

import java.util.List;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.CommunicationMessage;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;
import ru.yandex.direct.useractionlog.model.AutoUpdatedSettingsEvent;

public interface AutoUpdatedSettingsEventFormatter {

    /**
     * @param event событие об автоматическом изменение настроек (кампании, группы и т.п.)
     * @param eventVersion версия рекомендации
     * @param slots слоты
     * @param additionalInfo дополнительная информация (айдишники клиентов, операторов, валюта и т.п.)
     * @return готовые сообщения для отрисовки на фронте
     */
    List<CommunicationMessage> format(
            AutoUpdatedSettingsEvent event,
            CommunicationEventVersion eventVersion,
            List<Slot> slots,
            AdditionalInfoContainer additionalInfo
    );

    String getName();
}
