package ru.yandex.direct.communication.facade;

import java.util.List;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

/**
 * Интерфейс обработчика набора событий/рекомендаций
 */
public interface CommunicationEventVersionsProcessor {

    /**
     * Обработка набора событий/рекомендаций
     *
     * @param target        объект к которому применяются события
     * @param eventVersions набор версий событий
     * @param trigger       триггер который вызвал появления набора событий
     */
    void process(AdditionalInfoContainer target, List<CommunicationEventVersion> eventVersions,
                 String trigger);

    /**
     * @return имя обработчика набора событий/рекомендаций
     */
    String getName();
}
