package ru.yandex.direct.communication.facade;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.CommunicationMessage;
import ru.yandex.direct.communication.container.web.CommunicationMessageGroup;
import ru.yandex.direct.communication.container.web.SlotMessageId;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

public interface CommunicationMessageGroupFormatter {

    /**
     *
     * @param messages - сообщения
     * @param versionBySlotMessageId - конфигурации версий сообщений
     * @param additionalInfo - дополнительная информация для рассчета
     * @return готовые сообщения для выдачи
     */
    List<CommunicationMessageGroup> format(
            List<CommunicationMessage> messages,
            Map<SlotMessageId, CommunicationEventVersion> versionBySlotMessageId,
            AdditionalInfoContainer additionalInfo
    );

    String getName();
}
