package ru.yandex.direct.communication.facade;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.SlotMessageId;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

public interface ContextEntityKeyFinder<K> {

    /**
     * Находит ключи сущности определенного типа для переданных сообщений
     * @param messagesData сообщения
     * @param versionByMessageId версии сообщений по идентификаторам сообщений
     * @param slotById слоты сообщений
     */
    List<K> find(
            List<ObjectEventData> messagesData,
            Map<SlotMessageId, CommunicationEventVersion> versionByMessageId,
            Map<Long, Slot> slotById,
            AdditionalInfoContainer additionalInfo
    );

    String getName();

}
