package ru.yandex.direct.communication.facade;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.CommunicationMessage;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

public interface MessageSender {

    /**
     * Отправка сообщений в канал
     * @param messages сообщения
     * @param versionByMessageId версии событий по идентификаторам сообщений
     */
    void send(
            List<CommunicationMessage> messages,
            AdditionalInfoContainer additionalInfo,
            Map<Long, CommunicationEventVersion> versionByMessageId
    );

    String getName();
}
