package ru.yandex.direct.communication.facade;

import java.util.List;
import java.util.Map;
import java.util.Set;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.CommunicationMessageData;
import ru.yandex.direct.communication.container.web.SlotMessageId;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

public interface StatusChecker {

    /**
     *
     * @param messagesData - сообщения
     * @param caesarDataByMessageId - данные о сообщениях из Цезаря
     * @param versionByMessageId - конфигурации версий типов сообщения
     * @param slotById - конфигурации слотов
     * @param isActualByMessageId - актуальность сообщений
     * @param additionalInfo - дополнительная информация для рассчета
     * @return рекомендаций, которые следует отдать в ответ
     */
    Set<SlotMessageId> filterHidden(
            List<ObjectEventData> messagesData,
            Map<Long, CommunicationMessageData> caesarDataByMessageId,
            Map<SlotMessageId, CommunicationEventVersion> versionByMessageId,
            Map<Long, Slot> slotById,
            Map<SlotMessageId, Boolean> isActualByMessageId,
            AdditionalInfoContainer additionalInfo
    );

    String getName();
}
