package ru.yandex.direct.communication.facade.impl.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import ru.yandex.direct.communication.facade.ActionResult;
import ru.yandex.direct.communication.facade.SummaryActionResult;

public class ActionResultImpl implements ActionResult<ActionResultImpl> {

    private List<Long> successObjects;
    private List<Long> failedObjects;
    private SummaryActionResult result;
    private List<SubResult> subResults;

    public ActionResultImpl(Collection<Long> successObjects, Collection<Long> failedObjects) {
        this(successObjects, failedObjects, Collections.emptyList());
    }

    public ActionResultImpl(Collection<Long> successObjects, Collection<Long> failedObjects, List<SubResult> subResults) {
        this.successObjects = new ArrayList<>(successObjects);
        this.failedObjects = new ArrayList<>(failedObjects);
        this.subResults = new ArrayList<>(subResults);
        calcSummaryResult();
    }

    private void calcSummaryResult() {
        if (successObjects.isEmpty()) {
            result = failedObjects.isEmpty() ? SummaryActionResult.EMPTY : SummaryActionResult.FAILED;
        } else {
            result = failedObjects.isEmpty() ? SummaryActionResult.SUCCESS : SummaryActionResult.HALF;
        }
    }

    @Override
    public SummaryActionResult getResult() {
        return result;
    }

    @Override
    public ActionResultImpl merge(ActionResultImpl second) {
        successObjects.addAll(second.getSuccessObjects());
        failedObjects.addAll(second.getFailedObjects());
        subResults.addAll(second.getSubResults());
        calcSummaryResult();
        return this;
    }

    @Override
    public List<Long> getSuccessObjects() {
        return Collections.unmodifiableList(successObjects);
    }

    @Override
    public List<Long> getFailedObjects() {
        return Collections.unmodifiableList(failedObjects);
    }

    public List<SubResult> getSubResults() {
        return subResults;
    }
}
