package ru.yandex.direct.communication.facade.impl.actions;

import java.math.BigDecimal;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.CommunicationClient;
import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.CommunicationMessage;
import ru.yandex.direct.communication.facade.ActionTarget;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.core.entity.campaign.model.CampaignWithCustomStrategy;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.campaign.service.CampaignOperationService;
import ru.yandex.direct.core.entity.campaign.service.CampaignOptions;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.model.UidAndClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;
import ru.yandex.direct.model.ModelChanges;
import ru.yandex.direct.result.Result;

import static java.util.Collections.singleton;
import static java.util.Collections.singletonList;

@Component
public class ApplyWeeklyBudgetRecommendation extends AbstractApplyBudgetRecommendation {

    private final CampaignOperationService campaignOperationService;

    @Autowired
    public ApplyWeeklyBudgetRecommendation(
            CommunicationClient communicationClient,
            ShardHelper shardHelper,
            CampaignRepository campaignRepository,
            CampaignOperationService campaignOperationService
    ) {
        super(communicationClient, shardHelper, campaignRepository);
        this.campaignOperationService = campaignOperationService;
    }
    @Override
    public String getName() {
        return "APPLY_WEEKLY_BUDGET";
    }

    @Override
    ActionResultImpl applyUpdatedBudget(List eventsToSend, ActionTarget target,
                                        AdditionalInfoContainer additionalInfo, Slot slot,
                                        CommunicationMessage message, CommunicationEventVersion eventVersion) {
        var shard = shardHelper.getShardByClientIdStrictly(additionalInfo.getClientId().get());
        var campaignId = target.getTargetObjectId();
        var recommendedWeeklyBudget = (BigDecimal) message.getData().get("new_week_budget");
        var campaign = campaignRepository.getCampaigns(shard, singleton(campaignId)).get(0);
        var strategy = campaign.getStrategy();
        var uidAndClientId = UidAndClientId.of(campaign.getUserId(),
                ClientId.fromLong(campaign.getClientId()));
        var operatorUid = message.getUserId();
        var strategyData = strategy.getStrategyData();

        strategyData.setSum(recommendedWeeklyBudget);

        ModelChanges<CampaignWithCustomStrategy> changes = ModelChanges.build(campaignId,
                CampaignWithCustomStrategy.class, CampaignWithCustomStrategy.STRATEGY, strategy);

        var options = new CampaignOptions();
        Result<Long> result = campaignOperationService.createRestrictedCampaignUpdateOperation(
                singletonList(changes), operatorUid, uidAndClientId, options)
                .apply()
                .get(0);

        return super
                .getResult(result, campaignId, eventsToSend, target, additionalInfo, slot, eventVersion);
    }
}
