package ru.yandex.direct.communication.facade.impl.actions;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.CommunicationMessage;
import ru.yandex.direct.communication.facade.ActionHandler;
import ru.yandex.direct.communication.facade.ActionTarget;
import ru.yandex.direct.communication.facade.CommunicationEventVersionProcessingFacade;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class DefaultAction implements ActionHandler<ActionResultImpl> {
    @Override
    public String getName() {
        return CommunicationEventVersionProcessingFacade.DEFAULT_IMPLEMENTATION;
    }

    @Override
    public ActionResultImpl confirm(
            Map<Long, ActionTarget> targets,
            AdditionalInfoContainer additionalInfo,
            Slot slot,
            long buttonId,
            Map<Long, CommunicationMessage> messageById,
            Map<Long, CommunicationEventVersion> eventVersionByMessageId) {
        return new ActionResultImpl(mapList(targets.values(), ActionTarget::getTargetObjectId), List.of());
    }
}
