package ru.yandex.direct.communication.facade.impl.actions;

import java.util.Collection;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.ads.bsyeti.libs.communications.EMessageStatus;
import ru.yandex.direct.communication.CommunicationClient;
import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.CommunicationMessage;
import ru.yandex.direct.communication.facade.ActionTarget;
import ru.yandex.direct.communication.facade.impl.logging.RecommendationLogger;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersionStatus;

import static java.util.Collections.emptyList;
import static ru.yandex.direct.communication.CommunicationHelper.buildEventWithStatus;
import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class RejectAction extends AbstractClientAction<ActionResultImpl> {

    @Autowired
    public RejectAction(CommunicationClient communicationClient) {
        super(communicationClient);
    }

    @Override
    public String getName() {
        return "REJECT";
    }

    @Override
    protected ActionResultImpl failByReadOnly(Slot slot, Collection<ActionTarget> targets) {
        return new ActionResultImpl(emptyList(), mapList(targets, ActionTarget::getTargetObjectId));
    }

    @Override
    protected ActionResultImpl confirmInternal(
            List eventsToSend,
            ActionTarget target,
            AdditionalInfoContainer additionalInfo,
            Slot slot,
            long buttonId,
            CommunicationMessage message,
            CommunicationEventVersion eventVersion) {
        String failReason = null;
        if (eventVersion == null || !CommunicationEventVersionStatus.ACTIVE.equals(eventVersion.getStatus())) {
            failReason = "not_active_event";
        }
        if (failReason != null) {
            RecommendationLogger.logRejectFailed(additionalInfo, target, slot.getId(), failReason);
            return new ActionResultImpl(emptyList(), List.of(target.getTargetObjectId()));
        }
        RecommendationLogger.logReject(additionalInfo, target, slot.getId());
        eventsToSend.add(buildEventWithStatus(EMessageStatus.REJECT, target, eventVersion, additionalInfo));
        return new ActionResultImpl(List.of(target.getTargetObjectId()), emptyList());
    }
}
