package ru.yandex.direct.communication.facade.impl.actual;

import java.util.List;
import java.util.Map;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.SlotMessageId;
import ru.yandex.direct.communication.facade.ActualChecker;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;
import ru.yandex.direct.utils.FunctionalUtils;

public abstract class AbstractActualCheckerForClientEvents implements ActualChecker {

    @Override
    public Map<SlotMessageId, Boolean> check(
            List<ObjectEventData> messagesData,
            Map<SlotMessageId, CommunicationEventVersion> eventVersionByMessageId,
            AdditionalInfoContainer additionalInfo) {
        boolean isActual = isEventActualForClient(additionalInfo);
        return FunctionalUtils.listToMap(
                messagesData,
                SlotMessageId::of,
                data -> isActual
        );
    }

    /**
     * Проверка актуальности какого-то условия по клиенту и некоторой дополнительно информации целого запроса
     * @param additionalInfo
     * @return
     */
    abstract protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo);
}
