package ru.yandex.direct.communication.facade.impl.actual;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;

@Component
public class ActiveCampaignChecker extends AbstractActualCheckerForClientEvents {

    private final CampaignRepository campaignRepository;

    @Autowired
    public ActiveCampaignChecker(
            CampaignRepository campaignRepository
    ) {
        this.campaignRepository = campaignRepository;
    }

    @Override
    public String getName() {
        return "ACTIVE_CAMPAIGN";
    }

    /**
     * Проверяет есть ли у клиента универсальная кампания
     * @return true если нет активных кампаний
     */
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        ClientId clientId = additionalInfo.getClientId().get();
        int shard = additionalInfo.getShard().get();
        return campaignRepository
                .getActiveCampaignIdsByClientIds(shard, List.of(clientId))
                .isEmpty();
    }
}
