package ru.yandex.direct.communication.facade.impl.actual;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.campaign.repository.WalletRepository;
import ru.yandex.direct.core.entity.client.service.ClientService;
import ru.yandex.direct.currency.CurrencyCode;
import ru.yandex.direct.dbutil.model.ClientId;

@Component
public class AutopayChecker extends AbstractActualCheckerForClientEvents {

    private final ClientService clientService;
    private final WalletRepository walletRepository;

    @Autowired
    public AutopayChecker(
            ClientService clientService,
            WalletRepository walletRepository
    ) {
        this.clientService = clientService;
        this.walletRepository = walletRepository;
    }

    @Override
    public String getName() {
        return "AUTOPAY_ON";
    }

    /**
     * Проверяет включен ли автоплатеж у пользователя
     * @return true если выключен
     */
    @Override
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        ClientId clientId = additionalInfo.getClientId().get();
        int shard = additionalInfo.getShard().get();
        CurrencyCode currency = clientService.getWorkCurrency(clientId).getCode();
        Long walletCid = walletRepository.getActualClientWalletId(shard, clientId, currency);
        return !walletRepository.isAutopayEnabled(shard, walletCid);
    }
}
