package ru.yandex.direct.communication.facade.impl.actual;

import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.campaign.model.CampaignType;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;

@Component
public class BalanceChecker extends AbstractActualCheckerForClientEvents {

    private final CampaignRepository campaignRepository;

    @Autowired
    public BalanceChecker(
            CampaignRepository campaignRepository
    ) {
        this.campaignRepository = campaignRepository;
    }

    @Override
    public String getName() {
        return "TOP_UP_BALANCE";
    }

    /**
     * Проверяет пополнял ли клиент свой счет в Директе
     * @return true если ни разу не пополнял
     */
    @Override
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        ClientId clientId = additionalInfo.getClientId().get();
        int shard = additionalInfo.getShard().get();
        return !campaignRepository.didClientHaveAnyCampaignWithMoney(
                shard, clientId, Set.of(CampaignType.values())
        );
    }
}
