package ru.yandex.direct.communication.facade.impl.actual;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.metrika.repository.MetrikaCampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;

@Component
public class GoalUsedChecker extends AbstractActualCheckerForClientEvents {

    private final MetrikaCampaignRepository metrikaCampaignRepository;

    @Autowired
    public GoalUsedChecker(
            MetrikaCampaignRepository metrikaCampaignRepository
    ) {
        this.metrikaCampaignRepository = metrikaCampaignRepository;
    }

    @Override
    public String getName() {
        return "METRIKA_GOALS_USED";
    }

    /**
     * Проверяет используются ли цели метрики в настройках стратегий или как ключевые
     * @return true если цели не используются
     */
    @Override
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        ClientId clientId = additionalInfo.getClientId().get();
        int shard = additionalInfo.getShard().get();
        return metrikaCampaignRepository.getGoalsUsedInCampaignsByClientId(shard, clientId).isEmpty();
    }
}
