package ru.yandex.direct.communication.facade.impl.actual;

import java.math.BigDecimal;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.cashback.service.CashbackClientsService;

@Component
public class LastMonthBonusCreditedChecker extends AbstractActualCheckerForClientEvents {

    private final CashbackClientsService cashbackClientsService;

    @Autowired
    public LastMonthBonusCreditedChecker(CashbackClientsService cashbackClientsService) {
        this.cashbackClientsService = cashbackClientsService;
    }

    @Override
    public String getName() {
        return "LAST_MONTH_BONUS";
    }

    /**
     * Проверяет были ли начислены бонусы за прошлый месяц и все ли они уже зачислены на счет
     * @return true если за прошлый месяц поступили бонусы и все они зачислены на счет
     */
    @Override
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        var clientId = additionalInfo.getClientId().get();
        var cashbackInfo = cashbackClientsService.getClientCashbackInfo(clientId);
        return cashbackInfo != null &&
                cashbackInfo.getLastMonthCashbackWithoutNds().compareTo(BigDecimal.ZERO) > 0 &&
                cashbackInfo.getAwaitingCashback().equals(BigDecimal.ZERO);
    }
}
