package ru.yandex.direct.communication.facade.impl.actual;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.client.repository.ClientOptionsRepository;

@Component
public class MetrikaCounterInClientSettings extends AbstractActualCheckerForClientEvents {

    private final ClientOptionsRepository clientOptionsRepository;

    @Autowired
    public MetrikaCounterInClientSettings(
            ClientOptionsRepository clientOptionsRepository
    ) {
        this.clientOptionsRepository = clientOptionsRepository;
    }

    @Override
    public String getName() {
        return "METRIKA_COUNTER_SETTINGS";
    }

    /**
     * Проверяет наличие счетчика метрики по умолчанию в настройках клиента
     * @return true если счетчик не указан
     */
    @Override
    public boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        var clientId = additionalInfo.getClientId().get();
        var shard = additionalInfo.getShard().get();
        return clientOptionsRepository.getCommonMetrikaCountersByClientId(shard, List.of(clientId))
                .values()
                .stream()
                .filter(Objects::nonNull)
                .noneMatch(Predicate.not(Collection::isEmpty));
    }

}
