package ru.yandex.direct.communication.facade.impl.actual;

import java.util.List;
import java.util.function.Predicate;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.metrika.client.MetrikaClient;
import ru.yandex.direct.metrika.client.model.request.GetGoalsRequest;
import ru.yandex.direct.metrika.client.model.request.GoalType;
import ru.yandex.direct.rbac.RbacService;

@Component
public class MetrikaGoalChecker extends AbstractActualCheckerForClientEvents {

    private final RbacService rbacService;
    private final MetrikaClient metrikaClient;

    @Autowired
    public MetrikaGoalChecker(
            RbacService rbacService,
            MetrikaClient metrikaClient
    ) {
        this.rbacService = rbacService;
        this.metrikaClient = metrikaClient;
    }

    @Override
    public String getName() {
        return "METRIKA_GOAL";
    }

    /**
     * Проверяет наличие целей у счетчиков метрики представителей клиента
     * @return true если цели не найдены
     */
    @Override
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        var request = new GetGoalsRequest()
                .withUids(rbacService.getClientRepresentativesUids(additionalInfo.getClientId().get()))
                .withGoalType(GoalType.GOAL)
                .withCountCountersAsGoals(false);

        return metrikaClient.getGoals(request)
                .getUidToConditions()
                .values()
                .stream()
                .filter(Predicate.not(List::isEmpty))
                .findAny()
                .isEmpty();
    }
}
