package ru.yandex.direct.communication.facade.impl.actual;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.dbutil.model.ClientId;

@Component
public class MoneyNotificationChecker extends AbstractActualCheckerForClientEvents {

    private final CampaignRepository campaignRepository;

    @Autowired
    public MoneyNotificationChecker(
            CampaignRepository campaignRepository
    ) {
        this.campaignRepository = campaignRepository;
    }

    @Override
    public String getName() {
        return "MONEY_NOTIFICATION";
    }

    /**
     * Проверяет включенность нотификаций о достижении дневного бюджета по смс или почте
     * @return true если нотификации выключены
     */
    @Override
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        ClientId clientId = additionalInfo.getClientId().get();
        int shard = additionalInfo.getShard().get();
        return !campaignRepository.didClientHavePausedByDayBudgetNotification(shard, clientId);
    }
}
