package ru.yandex.direct.communication.facade.impl.actual;

import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.core.entity.campaign.repository.CampaignRepository;
import ru.yandex.direct.core.entity.organizations.repository.OrganizationRepository;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

@Component
public class OrganizationBindingChecker extends AbstractActualCheckerForClientEvents {

    private final CampaignRepository campaignRepository;
    private final OrganizationRepository organizationRepository;

    @Autowired
    public OrganizationBindingChecker(
            ShardHelper shardHelper,
            CampaignRepository campaignRepository,
            OrganizationRepository organizationRepository
    ) {
        this.campaignRepository = campaignRepository;
        this.organizationRepository = organizationRepository;
    }

    /**
     * Проверяет наличие привязанной к объявлениям организации Я.Бизнеса
     * @return true если ни одна организация не привязана
     */
    @Override
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        var clientId = additionalInfo.getClientId().get();
        var shard = additionalInfo.getShard().get();
        var cids = campaignRepository.getCampaignIdsByClientIds(shard, List.of(clientId));
        return organizationRepository.getPermalinkIdsByCampaignId(shard, cids).isEmpty();
    }

    @Override
    public String getName() {
        return "ORGANIZATION_BINDING";
    }
}
