package ru.yandex.direct.communication.facade.impl.actual;

import java.util.List;

import one.util.streamex.StreamEx;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.balance.client.BalanceClient;
import ru.yandex.direct.balance.client.model.response.GetClientPersonsResponseItem;
import ru.yandex.direct.communication.container.AdditionalInfoContainer;

import static ru.yandex.direct.utils.CommonUtils.nvl;

@Component
public class PayerChecker extends AbstractActualCheckerForClientEvents {

    private final BalanceClient balanceClient;

    @Autowired
    public PayerChecker(BalanceClient balanceClient) {
        this.balanceClient = balanceClient;
    }

    @Override
    public String getName() {
        return "CLIENT_HAS_PAYER";
    }

    /**
     * Проверяет наличие плательщика
     * @return true плательщик не зарегистрирован
     */
    @Override
    protected boolean isEventActualForClient(AdditionalInfoContainer additionalInfo) {
        var clientId = additionalInfo.getClientId().get();
        List<GetClientPersonsResponseItem> persons = balanceClient.getClientPersons(clientId.asLong());
        return !StreamEx.of(persons)
                .anyMatch(person -> nvl(person.getHidden(), 0).equals(0));
    }
}
