package ru.yandex.direct.communication.facade.impl.formatter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.fasterxml.jackson.databind.JsonNode;
import one.util.streamex.EntryStream;
import one.util.streamex.StreamEx;
import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;
import ru.yandex.direct.metrika.client.MetrikaClient;
import ru.yandex.direct.metrika.client.model.response.CounterGoal;

@Component
public class GoalRecommendationForUCAutobudgetFormatter extends DefaultFormatter {

    private MetrikaClient metrikaClient;

    public GoalRecommendationForUCAutobudgetFormatter(
            TranslationService translationService,
            MetrikaClient metrikaClient
    ) {
        super(translationService);
        this.metrikaClient = metrikaClient;
    }

    @Override
    public String getName() {
        return "UC_AUTOBUDGET_GOALS";
    }

    @Override
    protected Map<String, String> prepareTextParams(
            ObjectEventData objectEventData,
            Map<String, Object> data,
            AdditionalInfoContainer additionalInfo,
            CommunicationEventVersion version
    ) {
        List<String> goalIds = new ArrayList<>();
        List<String> goalNames = new ArrayList<>();
        getRetargetingConditions(data.get("goals"))
                .forEach(rc -> {
                    var goalId = Long.toString(rc.getId());
                    if (!goalIds.contains(goalId)) {
                        goalIds.add(goalId);
                    }
                    var goalName = "«" + rc.getName() + "»";
                    if (!goalNames.contains(goalName)) {
                        goalNames.add(goalName);
                    }
                });
        return EntryStream.of(super.prepareTextParams(objectEventData, data, additionalInfo, version))
                .append("yql.goals.names", String.join(", ", goalNames))
                .append("yql.goals.ids", String.join(",", goalIds))
                .toMap();
    }

    private List<CounterGoal> getRetargetingConditions(Object goals) {
        if (goals == null || !(goals instanceof JsonNode)) {
            return List.of();
        }
        var jsonGoals = (JsonNode) goals;
        if (!jsonGoals.isArray() || jsonGoals.size() < 1) {
            if (goals == null || !(goals instanceof JsonNode)) {
                return List.of();
            }
        }
        List<Integer> goalIds = new ArrayList<>();
        Set<Integer> counters = new HashSet<>();
        for (int i = 0; i < jsonGoals.size(); i++) {
            goalIds.add(jsonGoals.get(i).get("goal_id").asInt());
            counters.add(jsonGoals.get(i).get("metrika_counter").asInt());
        }
        return StreamEx.of(metrikaClient.getMassCountersGoalsFromMetrika(counters).values())
                .flatMap(Collection::stream)
                .mapToEntry(CounterGoal::getId)
                .filterValues(goalIds::contains)
                .sortedByInt(e -> goalIds.indexOf(e.getKey()))
                .keys()
                .toList();
    }
}
