package ru.yandex.direct.communication.facade.impl.formatter;

import java.util.HashMap;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.common.TranslationService;
import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

@Component
public class LastMonthBonusFormatter extends DefaultFormatter {

    public LastMonthBonusFormatter(TranslationService translationService) {
        super(translationService);
    }

    @Override
    public String getName() {
        return "LAST_MONTH_BONUS";
    }

    @Override
    protected Map<String, String> prepareTextParams(
            ObjectEventData objectEventData,
            Map<String, Object> data,
            AdditionalInfoContainer additionalInfo,
            CommunicationEventVersion version
    ) {
        var bonusKey = "yql.bonus";
        var result = new HashMap<>(super.prepareTextParams(objectEventData, data, additionalInfo, version));
        if (!result.containsKey(bonusKey)) {
            return result;
        }
        var bonus = result.getOrDefault(bonusKey, "");
        if (bonus.contains(".")) {
            result.put(bonusKey, bonus.split("\\.", 2)[0]);
        }
        return result;
    }
}
