package ru.yandex.direct.communication.facade.impl.keyfinder;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.container.web.SlotMessageId;
import ru.yandex.direct.communication.facade.ContextEntityKeyFinder;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class TargetObjectIdGetter implements ContextEntityKeyFinder<Long> {

    @Override
    public List<Long> find(
            List<ObjectEventData> messagesData,
            Map<SlotMessageId, CommunicationEventVersion> versionByMessageId,
            Map<Long, Slot> slotById,
            AdditionalInfoContainer additionalInfo
    ) {
        return mapList(messagesData, ObjectEventData::getObjectId);
    }

    @Override
    public String getName() {
        return "TARGET_OBJECT_ID";
    }
}
