package ru.yandex.direct.communication.facade.impl.logging;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.ads.bsyeti.libs.communications.EMessageStatus;
import ru.yandex.direct.communication.CommunicationHelper;
import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.facade.ActionTarget;
import ru.yandex.direct.communication.model.Slot;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.dbutil.model.ClientId;

public class RecommendationLogger {

    private static final String ACTION_NEW = "NEW";
    private static final String ACTION_UPDATE = "ACTUAL";
    private static final String ACTION_MUTE = "NOT_ACTUAL";
    private static final String ACTION_SKIP = "SKIP";
    private static final String ACTION_SELECT = "SELECT";
    private static final String ACTION_APPLY_FAILED = "APPLY_FAILED";
    private static final String ACTION_APPLY = "APPLY";
    private static final String ACTION_REJECT_FAILED = "REJECT_FAILED";
    private static final String ACTION_REJECT = "REJECT";

    private static Logger logger = LoggerFactory.getLogger(RecommendationLogger.class);

    public static void logCreateOrUpdate(
            ObjectEventData objectEventData,
            Slot slot,
            AdditionalInfoContainer additionalInfo,
            boolean isNew
    ) {
        log(objectEventData, slot, additionalInfo, isNew ? ACTION_NEW : ACTION_UPDATE, null);
    }

    public static void logSelect(
            ObjectEventData objectEventData,
            Slot slot,
            AdditionalInfoContainer additionalInfo
    ) {
        log(objectEventData, slot, additionalInfo, ACTION_SELECT, null);
    }

    public static void logMute(
            ObjectEventData objectEventData,
            Slot slot,
            AdditionalInfoContainer additionalInfo
    ) {
        log(objectEventData, slot, additionalInfo, ACTION_MUTE, null);
    }

    public static void logSkip(
            ObjectEventData objectEventData,
            Slot slot,
            AdditionalInfoContainer additionalInfo,
            EMessageStatus stopStatus
    ) {
        var reason = "ALREADY_" + stopStatus.name();
        logSkip(objectEventData, slot, additionalInfo, reason);
    }

    public static void logSkip(
            ObjectEventData objectEventData,
            Slot slot,
            AdditionalInfoContainer additionalInfo,
            String reason
    ) {
        log(objectEventData, slot, additionalInfo, ACTION_SKIP, reason);
    }

    public static void logReject(
            AdditionalInfoContainer additionalInfo,
            ActionTarget actionTarget,
            Long slotId) {
        var messageId = CommunicationHelper.calculateMessageId(
                additionalInfo.getUserId().orElse(null), additionalInfo.getClientId().orElse(null),
                actionTarget.getTargetObjectId(), actionTarget.getEventId());
        log(additionalInfo.getRequestId().orElse(null), messageId, actionTarget.getEventId(), actionTarget.getEventVersionId(),
                additionalInfo.getClientId().orElse(null), additionalInfo.getUserId().orElse(null), actionTarget.getTargetObjectId(),
                slotId,
                additionalInfo.getCurrentTimeStamp().orElse(null), ACTION_REJECT, null, actionTarget.getInventoryAdditionalData());
    }

    public static void logRejectFailed(
            AdditionalInfoContainer additionalInfo,
            ActionTarget actionTarget,
            Long slotId,
            String reason
    ) {
        var messageId = CommunicationHelper.calculateMessageId(
                additionalInfo.getUserId().orElse(null), additionalInfo.getClientId().orElse(null),
                actionTarget.getTargetObjectId(), actionTarget.getEventId());
        log(additionalInfo.getRequestId().orElse(null), messageId, actionTarget.getEventId(), actionTarget.getEventVersionId(),
                additionalInfo.getClientId().orElse(null), additionalInfo.getUserId().orElse(null), actionTarget.getTargetObjectId(), slotId,
                additionalInfo.getCurrentTimeStamp().orElse(null), ACTION_REJECT_FAILED, reason, actionTarget.getInventoryAdditionalData());
    }

    public static void logApply(
            AdditionalInfoContainer additionalInfo,
            ActionTarget actionTarget,
            Long slotId) {
        var messageId = CommunicationHelper.calculateMessageId(
                additionalInfo.getUserId().orElse(null), additionalInfo.getClientId().orElse(null),
                actionTarget.getTargetObjectId(), actionTarget.getEventId());
        log(additionalInfo.getRequestId().orElse(null), messageId, actionTarget.getEventId(), actionTarget.getEventVersionId(),
                additionalInfo.getClientId().orElse(null), additionalInfo.getUserId().orElse(null), actionTarget.getTargetObjectId(),
                slotId,
                additionalInfo.getCurrentTimeStamp().orElse(null), ACTION_APPLY, null, actionTarget.getInventoryAdditionalData());
    }

    public static void logApplyFailed(
            AdditionalInfoContainer additionalInfo,
            ActionTarget actionTarget,
            Long slotId,
            String reason
    ) {
        logApplyFailed(additionalInfo, actionTarget.getEventId(), actionTarget.getEventVersionId(),
                actionTarget.getTargetObjectId(), slotId, reason, actionTarget.getInventoryAdditionalData());
    }

    public static void logApplyFailed(
            AdditionalInfoContainer additionalInfo,
            Long eventId,
            Long eventVersionId,
            Long objectId,
            Long slotId,
            String reason,
            String additionalData
    ) {
        var messageId = CommunicationHelper.calculateMessageId(
                additionalInfo.getUserId().orElse(null), additionalInfo.getClientId().orElse(null),
                objectId, eventId);
        log(additionalInfo.getRequestId().orElse(null), messageId, eventId, eventVersionId,
                additionalInfo.getClientId().orElse(null), additionalInfo.getUserId().orElse(null), objectId, slotId,
                additionalInfo.getCurrentTimeStamp().orElse(null), ACTION_APPLY_FAILED, reason, additionalData);
    }

    private static void log(
            ObjectEventData objectEventData,
            Slot slot,
            AdditionalInfoContainer additionalInfo,
            String action,
            String reason
    ) {
        log(
                additionalInfo.getRequestId().orElse(null),
                objectEventData.getMessageId(),
                objectEventData.getEventId(),
                objectEventData.getEventVersionId(),
                additionalInfo.getClientId().orElse(null),
                additionalInfo.getUserId().orElse(null),
                objectEventData.getObjectId(),
                slot.getId(),
                additionalInfo.getCurrentTimeStamp().orElse(null),
                action,
                reason,
                objectEventData.getAdditionalData()
        );
    }

    private static void log(
            Long requestId,
            Long messageId,
            Long eventId,
            Long eventVersionId,
            ClientId clientId,
            Long operatorUid,
            Long objectId,
            Long slotId,
            Long time,
            String action,
            String reason,
            String additionalData
    ) {
        logger.info(String.format(
                "requestId=%d messageId=%d eventId=%d eventVersionId=%d clientId=%d operatorUid=%d" +
                        " objectId=%d slotId=%d time=%d action=%s reason=%s additionalData=%s",
                requestId,
                messageId,
                eventId,
                eventVersionId,
                clientId.asLong(),
                operatorUid,
                objectId,
                slotId,
                time,
                action,
                reason,
                additionalData
        ));
    }

}
