package ru.yandex.direct.communication.facade.impl.processors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.CommunicationHelper;
import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.facade.CommunicationEventVersionsProcessor;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.communication.model.inventory.Response;
import ru.yandex.direct.communication.model.inventory.SlotResponse;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;
import ru.yandex.direct.utils.DirectObjectMapper;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class ClientCashbackProcessor implements CommunicationEventVersionsProcessor {

    @Override
    public String getName() {
        return "CLIENT_CASHBACK";
    }

    @Override
    public void process(
            AdditionalInfoContainer additionalInfo,
            List<CommunicationEventVersion> eventVersions,
            String trigger) {
        additionalInfo.getAbstractInfo().get().put("response", getResponse(additionalInfo, eventVersions));
    }

    private Response getResponse(
            AdditionalInfoContainer additionalInfo,
            List<CommunicationEventVersion> versions
    ) {
        Set<Long> slotIds = new HashSet<>();
        versions.forEach(v -> slotIds.addAll(v.getSlots()));
        return Response.newBuilder()
                .addAllSlotResponses(mapList(slotIds, slotId -> SlotResponse.newBuilder()
                        .setSlotId(slotId)
                        .addAllObjectEventData(mapList(versions, v -> ObjectEventData.newBuilder()
                                .setEventId(v.getEventId())
                                .setEventVersionId(v.getIter())
                                .setObjectId(additionalInfo.getClientId().get().asLong())
                                .setMessageId(CommunicationHelper.calculateMessageId(
                                        null,
                                        additionalInfo.getClientId().orElse(null),
                                        additionalInfo.getClientId().get().asLong(),
                                        v.getEventId()
                                ))
                                .setSlotId(slotId)
                                .setData(new DirectObjectMapper()
                                        .writeValueAsString(additionalInfo.getAbstractInfo().get().get("params")))
                                .build())
                        ).build()
                )).build();
    }
}
