package ru.yandex.direct.communication.facade.impl.processors;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.direct.communication.CommunicationHelper;
import ru.yandex.direct.communication.container.AdditionalInfoContainer;
import ru.yandex.direct.communication.facade.CommunicationEventVersionsProcessor;
import ru.yandex.direct.communication.model.inventory.ObjectEventData;
import ru.yandex.direct.communication.model.inventory.Response;
import ru.yandex.direct.communication.model.inventory.SlotResponse;
import ru.yandex.direct.core.entity.communication.model.CommunicationEventVersion;
import ru.yandex.direct.core.entity.user.repository.UserRepository;
import ru.yandex.direct.dbutil.model.ClientId;
import ru.yandex.direct.dbutil.sharding.ShardHelper;

import static ru.yandex.direct.utils.FunctionalUtils.mapList;

@Component
public class MccRequestMailProcessor implements CommunicationEventVersionsProcessor {

    private final ShardHelper shardHelper;
    private final UserRepository userRepository;

    @Autowired
    public MccRequestMailProcessor(
            ShardHelper shardHelper,
            UserRepository userRepository
    ) {
        this.shardHelper = shardHelper;
        this.userRepository = userRepository;
    }

    @Override
    public String getName() {
        return "MCC_REQUEST";
    }
    @Override
    public void process(
            AdditionalInfoContainer additionalInfo,
            List<CommunicationEventVersion> eventVersions,
            String trigger) {
        additionalInfo.getAbstractInfo().get().put("response", getResponse(additionalInfo, eventVersions));
    }

    private Response getResponse(
            AdditionalInfoContainer additionalInfo,
            List<CommunicationEventVersion> versions
    ) {
        var managedClientId = (ClientId) additionalInfo.getAbstractInfo().get().get("managedClientId");
        var shard = shardHelper.getShardByClientId(managedClientId);
        var uid = userRepository.getChiefUidByClientId(shard, managedClientId.asLong());
        var login = userRepository.getLoginsByUids(List.of(uid)).getOrDefault(uid, "");
        Set<Long> slotIds = new HashSet<>();
        versions.forEach(v -> slotIds.addAll(v.getSlots()));
        return Response.newBuilder()
                .addAllSlotResponses(mapList(slotIds, slotId -> SlotResponse.newBuilder()
                        .setSlotId(slotId)
                        .addAllObjectEventData(mapList(versions, v -> ObjectEventData.newBuilder()
                                .setEventId(v.getEventId())
                                .setEventVersionId(v.getIter())
                                .setObjectId(managedClientId.asLong())
                                .setMessageId(CommunicationHelper.calculateMessageId(
                                        additionalInfo.getUserId().orElse(null),
                                        additionalInfo.getClientId().orElse(null),
                                        managedClientId.asLong(),
                                        v.getEventId()
                                ))
                                .setSlotId(slotId)
                                .setData("{\"managedClientId\":\"managedClientId\",\"managedLogin\":\"" + login + "\"}")
                                .build())
                        ).build()
                )).build();
    }
}
